package com.system.serivce.impl;

import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.core.utils.StringUtil;
import com.system.kingdee.PlugInUnitKingDeeApi;
import com.system.serivce.IPlugInUnitService;
import com.system.transfer.kingdee.KingDeeSynchronizationDataInVo;
import com.system.transfer.kingdee.KingDeeUpdateThirdDataInVo;
import com.system.utils.JsonUtil;
import com.system.utils.KingDeeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class PlugInUnitServiceImpl implements IPlugInUnitService {

    @Autowired
    private PlugInUnitKingDeeApi plugInUnitKingDeeApi;


    @Override
    public Object materialPlug(KingDeeUpdateThirdDataInVo inVo) {
        Map<String, Object> map = new LinkedHashMap<>(2);
        map.put("docType", inVo.getDocType());
        map.put("resultCode", "0002");

        List<Map<String, Object>> dataList = new ArrayList<>();
        for (Map<String, Object> data : inVo.getData()) {
            this.purchaseMaterial(data, map);

            dataList.add(data);
        }

        map.put("data", dataList);
        return map;
    }

    private void purchaseMaterial(Map<String, Object> data, Map<String, Object> map) {
        Map<String, String> materialKey = new LinkedHashMap<>(1);
        materialKey.put("FOldNumber", "FOldNumber");

        Map<String, String> materialWhere = new HashMap<>(1);
        if (data.containsKey("MTRL_CODE")) {
            materialWhere.put("FNumber", String.valueOf(data.get("MTRL_CODE")));
        } else if (data.containsKey("MTRL_ID")) {
            materialWhere.put("FNumber", String.valueOf(data.get("MTRL_ID")));
        }


        String errorName = "Errors";
        List<List<Object>> tempList = plugInUnitKingDeeApi.getKingDeeData("BD_MATERIAL", materialKey, materialWhere);
        if (!CollectionUtils.isEmpty(tempList)) {
            if (!tempList.get(0).get(0).toString().contains(errorName)) {
                if (StringUtil.isNotBlank(String.valueOf(tempList.get(0).get(0)))) {
                    data.put("MTRL_CODE", tempList.get(0).get(0));
                    map.put("resultCode", "0000");
                } else {
                    map.put("resultMsg", "物料编码不存在");
                }
            } else {
                map.put("resultMsg", "物料编码不存在");
            }
        } else {
            map.put("resultMsg", "物料编码不存在");
        }
    }

    @Override
    public Object productionMaterialListPlug(KingDeeUpdateThirdDataInVo inVo) {
        long start = System.currentTimeMillis();

        Map<String, Object> map = new LinkedHashMap<>(2);
        map.put("docType", inVo.getDocType());
        map.put("resultCode", "0002");

        Map<String, Object> moMap = new HashMap<>(10);
        List<String> moCodeList = inVo.getData().stream().map(m -> String.valueOf(m.get("MO_CODE"))).distinct().collect(Collectors.toList());
        List<String> moMesCodeList = inVo.getData().stream().map(m -> String.valueOf(m.get("MO_MES_CODE"))).distinct().collect(Collectors.toList());

        Map<String, String> tempKey = new LinkedHashMap<>(1);
        tempKey.put("FBillNo", "FBillNo");
        tempKey.put("F_LQKJ_Code", "F_LQKJ_Code");
        tempKey.put("FTreeEntity_FSeq", "FTreeEntity_FSeq");
        String errorName = "Errors";
        Map<String, Object> tempWhere = new HashMap<>(1);
        tempWhere.put("FBillNo", moCodeList);
        tempWhere.put("F_LQKJ_Code", moMesCodeList);
        List<List<Object>> data01List = plugInUnitKingDeeApi.getKingDeeDataList("PRD_MO", tempKey, tempWhere);
        if (!CollectionUtils.isEmpty(data01List)) {
            getTemp(map, errorName, moMap, data01List);
        } else {
            map.put("resultMsg", "生产订单编码: " + moCodeList + " MES主键为: " + moMesCodeList + " 的数据未查到");
        }

        Map<String, Object> omMap = new HashMap<>(10);
        List<String> moSeqList = inVo.getData().stream().map(m -> String.valueOf(moMap.get(m.get("MO_CODE") + "&" + m.get("MO_MES_CODE")))).distinct().collect(Collectors.toList());

        Map<String, String> key = new LinkedHashMap<>(1);
        key.put("FMoBillNo1", "FMoBillNo1");
        key.put("FMoEntrySeq1", "FMoEntrySeq1");
        key.put("FID", "FID");
        Map<String, Object> where = new HashMap<>(1);
        where.put("FMoBillNo1", moCodeList);
        where.put("FMoEntrySeq1", moSeqList);
        List<List<Object>> data02List = plugInUnitKingDeeApi.getKingDeeDataList("PRD_PPBOM", key, where);
        if (!CollectionUtils.isEmpty(data02List)) {
            getTemp(map, errorName, omMap, data02List);
        } else {
            map.put("resultMsg", "生产订单编码为: " + moCodeList + " 行号为: " + moSeqList + " 的数据未查到");
        }

        List<Map<String, Object>> dataList = new ArrayList<>();
        for (Map<String, Object> data : inVo.getData()) {
            data.remove("MO_SEQ");
            data.put("MO_SEQ", moMap.get(data.get("MO_CODE") + "&" + data.get("MO_MES_CODE")));
            if (data.containsKey("MO_SEQ")) {
                if (StringUtil.isNotNull(omMap.get(data.get("MO_CODE") + "&" + data.get("MO_SEQ")))) {
                    String fid = String.valueOf(omMap.get(data.get("MO_CODE") + "&" + data.get("MO_SEQ")));
                    if (StringUtil.isNoneBlank(fid)) {
                        data.put("ERP_FID", fid);
                        map.put("resultCode", "0000");
                    } else {
                        map.put("resultCode", "0002");
                        map.put("resultMsg", "生产订单编码为: " + data.get("MO_CODE") + " 行号为: " + data.get("MO_SEQ") + " 的数据未查到");
                    }
                } else {
                    map.put("resultCode", "0002");
                    map.put("resultMsg", "生产订单编码为: " + data.get("MO_CODE") + " 行号为: " + data.get("MO_SEQ") + " 的数据未查到");
                }
            }

            if (data.containsKey("ERP_FID")) {
                Map<String, String> detailKey = new HashMap<>(1);
                detailKey.put("FEntity_FEntryID", "FEntity_FEntryID");
                Map<String, String> detailWhere = new HashMap<>(1);
                detailWhere.put("FID", String.valueOf(data.get("ERP_FID")));
                detailWhere.put("FMaterialID2.FNumber", String.valueOf(data.get("MTRL_CODE")));
                List<List<Object>> data03List = plugInUnitKingDeeApi.getKingDeeData("PRD_PPBOM", detailKey, detailWhere);
                if (!CollectionUtils.isEmpty(data03List)) {
                    if (!data03List.get(0).get(0).toString().contains(errorName)) {
                        data.put("ERP_SIC", data03List.get(0).get(0));
                    }
                }
            }

            dataList.add(data);
        }

        map.put("data", dataList);
        System.out.println("==========>" + (System.currentTimeMillis() - start));
        return map;
    }

    private void getTemp(Map<String, Object> map, String errorName, Map<String, Object> omMap, List<List<Object>> data02List) {
        if (!data02List.get(0).get(0).toString().contains(errorName)) {
            for (List<Object> objectList : data02List) {
                omMap.put(objectList.get(0) + "&" + objectList.get(1), objectList.get(2).toString());
            }
        } else {
            map.put("resultMsg", KingDeeUtil.getMessage(data02List.get(0).get(0)));
        }
    }

    @Override
    public Object productionPickingPlug(KingDeeUpdateThirdDataInVo inVo) {
        long start = System.currentTimeMillis();
        Map<String, Object> map = new LinkedHashMap<>(2);
        map.put("docType", inVo.getDocType());
        map.put("resultCode", "0002");

        List<Map<String, Object>> dataList = new ArrayList<>();
        for (Map<String, Object> data : inVo.getData()) {
            Map<String, String> key = new LinkedHashMap<>(1);
            key.put("FEntity_FEntryId", "FEntity_FEntryId");

            Map<String, String> where = new HashMap<>(1);
            where.put("FBillNo", String.valueOf(data.get("MO_CODE")));
            where.put("F_LQKJ_Code", String.valueOf(data.get("MES_CODE")));

            String errorName = "Errors";
            List<List<Object>> data01List = plugInUnitKingDeeApi.getKingDeeData("PRD_PPBOM", key, where);
            if (!CollectionUtils.isEmpty(data01List)) {
                if (!data01List.get(0).get(0).toString().contains(errorName)) {
                    data.put("ERP_SIC", data01List.get(0).get(0));
                    map.put("resultCode", "0000");
                } else {
                    map.put("resultMsg", KingDeeUtil.getMessage(data01List.get(0).get(0)));
                }
            } else {
                map.put("resultCode", "0002");
                map.put("resultMsg", "生产用料清单编码: " + data.get("MO_CODE") + " MES主键为: " + data.get("MES_CODE") + " 的数据未查到");
            }

            dataList.add(data);
        }

        map.put("data", dataList);
        System.out.println("==========>" + (System.currentTimeMillis() - start));
        return map;
    }

    @Override
    public Object productionWarehousingPlug(KingDeeUpdateThirdDataInVo inVo) {
        long start = System.currentTimeMillis();
        Map<String, Object> map = new LinkedHashMap<>(2);
        map.put("docType", inVo.getDocType());
        map.put("resultCode", "0002");

        List<Map<String, Object>> dataList = new ArrayList<>();
        for (Map<String, Object> data : inVo.getData()) {
            Map<String, String> key = new LinkedHashMap<>(1);
            key.put("FTreeEntity_FEntryID", "FTreeEntity_FEntryID");

            Map<String, String> where = new HashMap<>(1);
            where.put("FBillNo", String.valueOf(data.get("ERP_MO")));
            where.put("F_LQKJ_Code", String.valueOf(data.get("MES_CODE")));

            String errorName = "Errors";
            List<List<Object>> data01List = plugInUnitKingDeeApi.getKingDeeData("PRD_MO", key, where);
            if (!CollectionUtils.isEmpty(data01List)) {
                if (!data01List.get(0).get(0).toString().contains(errorName)) {
                    data.put("ERP_SIC", data01List.get(0).get(0));
                    map.put("resultCode", "0000");
                } else {
                    map.put("resultMsg", KingDeeUtil.getMessage(data01List.get(0).get(0)));
                }
            } else {
                map.put("resultCode", "0002");
                map.put("resultMsg", "生产订单编码: " + data.get("ERP_MO") + " MES主键为: " + data.get("MES_CODE") + " 的数据未查到");
            }

            dataList.add(data);
        }

        map.put("data", dataList);
        System.out.println("==========>" + (System.currentTimeMillis() - start));
        return map;
    }

    @Override
    public Object materialsListPlug(KingDeeSynchronizationDataInVo inVo) {
        long start = System.currentTimeMillis();
        List<Object> list = new ArrayList<>();
        Map<String, Object> result = new LinkedHashMap<>();

        List<Map<String, Object>> tempList = inVo.getData().stream()
                .map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class))
                .filter(m -> "1".equals(String.valueOf(m.get("Lev"))))
                .collect(Collectors.toList());
        for (Map<String, Object> map : tempList) {
            result.put("prod_code", map.get("FMATERIALID"));
            result.put("fprod_code", map.get("F_ora_BaseProperty1"));
            result.put("flag", map.get("FForbidStatus"));
            result.put("bom_ver", map.get("FNumber"));
        }

        List<Map<String, Object>> childrenList = new ArrayList<>();
        for (Object object : tempList) {
            Map<String, Object> temp = JsonUtil.toMap(JsonUtil.toString(object), String.class, Object.class);

            Map<String, Object> data = this.getDataMap(temp);
            data.put("children", this.getTree(String.valueOf(data.get("mtrl_code")), inVo.getData()));

            childrenList.add(data);
        }
        result.put("bs_bom_mtrl", childrenList);

        list.add(result);
        System.out.println("==========>" + (System.currentTimeMillis() - start));
        return list;
    }

    private List<Map<String, Object>> getTree(String code, List<Object> tempList) {
        List<Map<String, Object>> result = new ArrayList<>();

        List<Map<String, Object>> rootList = tempList.stream()
                .map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class))
                .filter(m -> !"null".equals(m.get("FMATERIALID")) && m.get("FMATERIALID").equals(code))
                .collect(Collectors.toList());

        for (Map<String, Object> map : rootList) {
            Map<String, Object> data = this.getDataMap(map);
            data.put("children", getTree(String.valueOf(map.get("")), tempList));
            result.add(data);
        }
        return result;
    }

    private Map<String, Object> getDataMap(Map<String, Object> temp) {
        Map<String, Object> request = new LinkedHashMap<>();
        request.put("mtrl_code", temp.get("FMATERIALIDCHILD"));
        request.put("mes_mtrl_code", temp.get("F_ora_BaseProperty2"));
        String fIskeyItem = String.valueOf(temp.get("FIskeyItem"));
        if (!Constants.NULL.equals(fIskeyItem) && StringUtil.isNotBlank(fIskeyItem)) {
            request.put("main_code", fIskeyItem);
            request.put("is_main", false);
        } else {
            request.put("main_code", temp.get("FMATERIALIDCHILD"));
            request.put("is_main", true);
        }
        request.put("dosage", temp.get("dosage"));
        request.put("point_str", temp.get("FPOSITIONNO"));
        request.put("remark", temp.get("FMEMO"));

        return request;
    }

    @Override
    public Object supplierListPlug(KingDeeSynchronizationDataInVo inVo) {
        long start = System.currentTimeMillis();
        List<Object> result = new LinkedList<>();

        for (Object object : inVo.getData()) {
            Map<String, Object> temp = JsonUtil.toMap(JsonUtil.toString(object), String.class, Object.class);

            List<Object> objectList = JsonUtil.toList(JsonUtil.toString(temp.get("bs_sup_dt")), Object.class);
            Map<String, Object> map = objectList.stream()
                    .map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class))
                    .filter(m -> "true".equals(String.valueOf(m.get("is_contactIs_default"))))
                    .findFirst().orElse(new HashMap<>(1));

            if (!CollectionUtils.isEmpty(map)) {
                temp.put("Default_contacts_user", map.get("contacts_user"));
                temp.put("Default_contacts_phone", map.get("contacts_phone"));
            } else {
                temp.put("Default_contacts_user", "");
                temp.put("Default_contacts_phone", "");
            }

            result.add(temp);
        }

        System.out.println("==========>" + (System.currentTimeMillis() - start));
        return result;
    }


}
