package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.dao.ThirdPartyLogMapper;
import com.system.serivce.IThirdPartyLogService;
import com.system.transfer.kingdee.ThirdPartyLogListInVo;
import com.system.transfer.kingdee.ThirdPartyLogListOutVo;
import com.system.transfer.kingdee.ThirdPartyLogListOutVoRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Inori
 */
@Service
public class ThirdPartyLogServiceImpl implements IThirdPartyLogService {

    @Autowired
    private ThirdPartyLogMapper thirdPartyLogMapper;


    @Override
    public ThirdPartyLogListOutVo thirdPartyLogList(ThirdPartyLogListInVo inVo) {
        Page<ThirdPartyLogListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<ThirdPartyLogListOutVoRecords> recordsList = thirdPartyLogMapper.thirdPartyLogList(page, inVo);

        ThirdPartyLogListOutVo outVo = new ThirdPartyLogListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }


}
