/*
 Navicat Premium Data Transfer

 Source Server         : 192.168.50.211
 Source Server Type    : MySQL
 Source Server Version : 80027
 Source Host           : 192.168.50.211:3306
 Source Schema         : db_semiconductor

 Target Server Type    : MySQL
 Target Server Version : 80027
 File Encoding         : 65001

 Date: 01/11/2022 11:52:00
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for oauth_client_details
-- ----------------------------
DROP TABLE IF EXISTS `oauth_client_details`;
CREATE TABLE `oauth_client_details`  (
  `client_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `resource_ids` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `client_secret` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `scope` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `authorized_grant_types` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `web_server_redirect_uri` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `authorities` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `access_token_validity` int NULL DEFAULT NULL,
  `refresh_token_validity` int NULL DEFAULT NULL,
  `additional_information` varchar(4096) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `autoapprove` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`client_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of oauth_client_details
-- ----------------------------
INSERT INTO `oauth_client_details` VALUES ('auth-client', NULL, '$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq', 'all', 'authorization_code,refresh_token,password', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `oauth_client_details` VALUES ('codegenerator-client', NULL, '$2a$10$pKOYERvA7GXe9nsY6arlauD87nnG5OriMJCOlVOOOzqI0AMKDP/hK', 'all', 'authorization_code,refresh_token,password', NULL, NULL, 3600, 36000, NULL, '1');
INSERT INTO `oauth_client_details` VALUES ('user-client', NULL, '$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq', 'all', 'authorization_code,refresh_token,password', NULL, NULL, 7200, 36000, NULL, '1');

-- ----------------------------
-- Table structure for qrtz_blob_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_blob_triggers`;
CREATE TABLE `qrtz_blob_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `BLOB_DATA` blob NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_blob_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_calendars
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_calendars`;
CREATE TABLE `qrtz_calendars`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `CALENDAR_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `CALENDAR` blob NOT NULL,
  PRIMARY KEY (`SCHED_NAME`, `CALENDAR_NAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_calendars
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_cron_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_cron_triggers`;
CREATE TABLE `qrtz_cron_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `CRON_EXPRESSION` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TIME_ZONE_ID` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_cron_triggers
-- ----------------------------
INSERT INTO `qrtz_cron_triggers` VALUES ('DefaultQuartzScheduler', 'com.system.quartz.job.SynchronizationJob', 'DEFAULT', '0 */1  * * * ?', 'Asia/Shanghai');

-- ----------------------------
-- Table structure for qrtz_fired_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_fired_triggers`;
CREATE TABLE `qrtz_fired_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `ENTRY_ID` varchar(95) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `INSTANCE_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `FIRED_TIME` bigint NOT NULL,
  `SCHED_TIME` bigint NOT NULL,
  `PRIORITY` int NOT NULL,
  `STATE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `IS_NONCONCURRENT` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `REQUESTS_RECOVERY` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`, `ENTRY_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_fired_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_job_details
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_job_details`;
CREATE TABLE `qrtz_job_details`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `DESCRIPTION` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `JOB_CLASS_NAME` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `IS_DURABLE` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `IS_NONCONCURRENT` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `IS_UPDATE_DATA` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `REQUESTS_RECOVERY` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_DATA` blob NULL,
  PRIMARY KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_job_details
-- ----------------------------
INSERT INTO `qrtz_job_details` VALUES ('DefaultQuartzScheduler', 'com.system.quartz.job.SynchronizationJob', 'DEFAULT', NULL, 'com.system.quartz.job.SynchronizationJob', '0', '0', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C77080000001000000001740009706172616D657465727400007800);

-- ----------------------------
-- Table structure for qrtz_locks
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_locks`;
CREATE TABLE `qrtz_locks`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `LOCK_NAME` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`SCHED_NAME`, `LOCK_NAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_locks
-- ----------------------------
INSERT INTO `qrtz_locks` VALUES ('DefaultQuartzScheduler', 'STATE_ACCESS');
INSERT INTO `qrtz_locks` VALUES ('DefaultQuartzScheduler', 'TRIGGER_ACCESS');

-- ----------------------------
-- Table structure for qrtz_paused_trigger_grps
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;
CREATE TABLE `qrtz_paused_trigger_grps`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_GROUP`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_paused_trigger_grps
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_scheduler_state
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_scheduler_state`;
CREATE TABLE `qrtz_scheduler_state`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `INSTANCE_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `LAST_CHECKIN_TIME` bigint NOT NULL,
  `CHECKIN_INTERVAL` bigint NOT NULL,
  PRIMARY KEY (`SCHED_NAME`, `INSTANCE_NAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_scheduler_state
-- ----------------------------
INSERT INTO `qrtz_scheduler_state` VALUES ('DefaultQuartzScheduler', '7280f1d91a8c1666854499360', 1667274754530, 10000);

-- ----------------------------
-- Table structure for qrtz_simple_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simple_triggers`;
CREATE TABLE `qrtz_simple_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `REPEAT_COUNT` bigint NOT NULL,
  `REPEAT_INTERVAL` bigint NOT NULL,
  `TIMES_TRIGGERED` bigint NOT NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_simple_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_simprop_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simprop_triggers`;
CREATE TABLE `qrtz_simprop_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `STR_PROP_1` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `STR_PROP_2` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `STR_PROP_3` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `INT_PROP_1` int NULL DEFAULT NULL,
  `INT_PROP_2` int NULL DEFAULT NULL,
  `LONG_PROP_1` bigint NULL DEFAULT NULL,
  `LONG_PROP_2` bigint NULL DEFAULT NULL,
  `DEC_PROP_1` decimal(13, 4) NULL DEFAULT NULL,
  `DEC_PROP_2` decimal(13, 4) NULL DEFAULT NULL,
  `BOOL_PROP_1` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `BOOL_PROP_2` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_simprop_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_triggers`;
CREATE TABLE `qrtz_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `DESCRIPTION` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `NEXT_FIRE_TIME` bigint NULL DEFAULT NULL,
  `PREV_FIRE_TIME` bigint NULL DEFAULT NULL,
  `PRIORITY` int NULL DEFAULT NULL,
  `TRIGGER_STATE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_TYPE` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `START_TIME` bigint NOT NULL,
  `END_TIME` bigint NULL DEFAULT NULL,
  `CALENDAR_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `MISFIRE_INSTR` smallint NULL DEFAULT NULL,
  `JOB_DATA` blob NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) USING BTREE,
  INDEX `SCHED_NAME`(`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) REFERENCES `qrtz_job_details` (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of qrtz_triggers
-- ----------------------------
INSERT INTO `qrtz_triggers` VALUES ('DefaultQuartzScheduler', 'com.system.quartz.job.SynchronizationJob', 'DEFAULT', 'com.system.quartz.job.SynchronizationJob', 'DEFAULT', NULL, 1667274780000, 1667274720000, 5, 'WAITING', 'CRON', 1666853000000, 0, NULL, 0, '');

-- ----------------------------
-- Table structure for sys_depart
-- ----------------------------
DROP TABLE IF EXISTS `sys_depart`;
CREATE TABLE `sys_depart`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
  `parent_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '父机构ID',
  `depart_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '机构/部门名称',
  `description` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `depart_order` int NULL DEFAULT 0 COMMENT '排序',
  `org_category` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '1' COMMENT '机构类别 1组织机构，2岗位',
  `org_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '机构类型 1一级部门 2子部门',
  `org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '机构编码',
  `status` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态（1启用，0不启用）',
  `del_flag` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uniq_depart_org_code`(`org_code`) USING BTREE,
  INDEX `index_depart_parent_id`(`parent_id`) USING BTREE,
  INDEX `index_depart_depart_order`(`depart_order`) USING BTREE,
  INDEX `index_depart_org_code`(`org_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '组织机构表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of sys_depart
-- ----------------------------

-- ----------------------------
-- Table structure for sys_fill_rule
-- ----------------------------
DROP TABLE IF EXISTS `sys_fill_rule`;
CREATE TABLE `sys_fill_rule`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `rule_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '规则名称',
  `rule_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '规则Code',
  `rule_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '规则实现类',
  `rule_params` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '规则参数',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uni_sys_fill_rule_code`(`rule_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of sys_fill_rule
-- ----------------------------
INSERT INTO `sys_fill_rule` VALUES ('1202551334738382850', '机构编码生成', 'org_num_role', 'com.starbos.cloud.oauth.system.rule.OrgCodeRule', '{\"parentId\":\"c6d7cb4deeac411cb3384b1b31278596\"}', 'admin', '2022-05-18 12:00:20', 'admin', '2022-05-18 12:00:12');

-- ----------------------------
-- Table structure for sys_permission
-- ----------------------------
DROP TABLE IF EXISTS `sys_permission`;
CREATE TABLE `sys_permission`  (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编码',
  `fsort` bigint NULL DEFAULT NULL COMMENT '排序',
  `type` int NOT NULL DEFAULT 1 COMMENT '菜单类型(0:一级菜单; 1:子菜单:2:按钮权限)',
  `perm_tag` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表单key',
  `path` varchar(258) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '路径',
  `component` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '组件',
  `title` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '菜单名称',
  `icon` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '菜单图标',
  `parent_id` bigint NOT NULL DEFAULT 0 COMMENT '父节点',
  `is_leaf` tinyint(1) NULL DEFAULT 1 COMMENT '是否叶子节点:    1:是   0:不是',
  `sort_no` double(8, 2) NULL DEFAULT NULL COMMENT '菜单排序',
  `fremarks` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '备注',
  `fstatus` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '1' COMMENT '状态',
  `Fmodify_date` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新人',
  `fdate` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `fcreator` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `idx_tag`(`perm_tag`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 18 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_permission
-- ----------------------------
INSERT INTO `sys_permission` VALUES (1, 0, 0, 'system', '/system', 'Layout', '系统管理', 'Setting', 0, 0, 0.00, '', '', '2022-08-01 09:50:54', '', '2022-03-31 17:21:29', '');
INSERT INTO `sys_permission` VALUES (2, 0, 1, 'menu', '/menu', '/system/menuManage', '菜单管理', '', 1, 1, 2.00, '', '', '2022-08-01 11:27:13', '', '2022-03-31 18:19:39', '');
INSERT INTO `sys_permission` VALUES (3, 0, 1, 'role', '/role', '/system/roleManage', '角色管理', '', 1, 1, 3.00, '', '', '2022-08-01 11:27:14', '', '2022-04-02 17:16:42', '');
INSERT INTO `sys_permission` VALUES (4, 0, 1, 'user', '/user', '/system/userManage', '用户管理', '', 1, 1, 4.00, '', '', '2022-08-08 09:47:47', '', '2022-04-15 10:45:07', '');
INSERT INTO `sys_permission` VALUES (6, NULL, 1, 'synchronization', '/synchronization', '/system/enableSynchronization', '启用同步', '', 11, 1, 1.00, '', '1', '2022-08-08 17:37:35', '', '2022-08-01 14:38:57', '');
INSERT INTO `sys_permission` VALUES (7, NULL, 1, 'fieldConfiguration', '/fieldConfiguration', '/manage/fieldConfiguration', '表单字段配置', '', 11, 1, 2.00, '', '1', '2022-08-05 17:30:53', '', '2022-08-01 14:39:54', '');
INSERT INTO `sys_permission` VALUES (8, NULL, 1, 'kingdeeLog', '/kingdeeLog', '/manage/kingdeeLog', '金蝶日志', '', 11, 1, 3.00, '', '1', '2022-08-04 09:03:10', '', '2022-08-01 14:44:30', '');
INSERT INTO `sys_permission` VALUES (9, NULL, 1, 'thirdPartyLog', '/thirdPartyLog', '/manage/thirdPartyLog', '第三方日志', '', 11, 1, 4.00, '', '1', '2022-08-08 09:30:42', '', '2022-08-01 14:45:50', '');
INSERT INTO `sys_permission` VALUES (11, NULL, 0, 'manage', '/manage', 'Layout', '集成管理', 'Tickets', 0, 0, 0.00, '', '1', '2022-08-08 17:15:28', '', '2022-08-04 08:55:24', '');
INSERT INTO `sys_permission` VALUES (16, NULL, 1, 'synchronousMonitoring', '/synchronousMonitoring', '/manage/synchronousMonitoring', '同步监控', '', 11, 1, 5.00, '', '1', '2022-08-08 17:37:44', '', '2022-08-08 17:37:24', '');

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role`  (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `role_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `role_Name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `role_Desc` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `Fmodify_date` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新人',
  `fdate` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `fcreator` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES (1, 'admin', '管理员', '管理员', '2022-04-21 11:32:51', 'admin', '2022-03-31 17:21:29', '');

-- ----------------------------
-- Table structure for sys_role_permission
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_permission`;
CREATE TABLE `sys_role_permission`  (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `role_id` bigint NOT NULL,
  `perm_id` bigint NOT NULL,
  `Fmodify_date` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新人',
  `fdate` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `fcreator` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `idx_role_prem_id`(`role_id`, `perm_id`) USING BTREE,
  INDEX `idx_perm_id`(`perm_id`) USING BTREE,
  INDEX `idx_role_id`(`perm_id`) USING BTREE,
  CONSTRAINT `sys_role_permission_ibfk_1` FOREIGN KEY (`perm_id`) REFERENCES `sys_permission` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `sys_role_permission_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 24 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_permission
-- ----------------------------
INSERT INTO `sys_role_permission` VALUES (1, 1, 1, '2022-08-01 09:52:02', '', '2022-08-01 09:52:02', '');
INSERT INTO `sys_role_permission` VALUES (2, 1, 2, '2022-08-01 09:52:03', '', '2022-08-01 09:52:03', '');
INSERT INTO `sys_role_permission` VALUES (3, 1, 3, '2022-08-01 09:52:05', '', '2022-08-01 09:52:05', '');
INSERT INTO `sys_role_permission` VALUES (4, 1, 4, '2022-08-01 09:52:06', '', '2022-08-01 09:52:06', '');
INSERT INTO `sys_role_permission` VALUES (6, 1, 6, '2022-08-01 14:40:37', '', '2022-08-01 14:40:37', '');
INSERT INTO `sys_role_permission` VALUES (7, 1, 7, '2022-08-01 14:40:37', '', '2022-08-01 14:40:37', '');
INSERT INTO `sys_role_permission` VALUES (8, 1, 8, '2022-08-01 14:46:00', '', '2022-08-01 14:46:00', '');
INSERT INTO `sys_role_permission` VALUES (21, 1, 11, '2022-08-06 16:38:22', '', '2022-08-06 16:38:22', '');
INSERT INTO `sys_role_permission` VALUES (22, 1, 9, '2022-08-06 16:38:29', '', '2022-08-06 16:38:29', '');
INSERT INTO `sys_role_permission` VALUES (23, 1, 16, '2022-08-08 17:37:53', '', '2022-08-08 17:37:53', '');

-- ----------------------------
-- Table structure for sys_sms
-- ----------------------------
DROP TABLE IF EXISTS `sys_sms`;
CREATE TABLE `sys_sms`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
  `es_title` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息标题',
  `es_type` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发送方式：1短信 2邮件 3微信',
  `es_receiver` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接收人',
  `es_param` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发送所需参数Json格式',
  `es_content` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '推送内容',
  `es_send_time` datetime(0) NULL DEFAULT NULL COMMENT '推送时间',
  `es_send_status` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '推送状态 0未推送 1推送成功 2推送失败 -1失败不再发送',
  `es_send_num` int NULL DEFAULT NULL COMMENT '发送次数 超过5次不再发送',
  `es_result` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '推送失败原因',
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_type`(`es_type`) USING BTREE,
  INDEX `index_receiver`(`es_receiver`) USING BTREE,
  INDEX `index_sendtime`(`es_send_time`) USING BTREE,
  INDEX `index_status`(`es_send_status`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of sys_sms
-- ----------------------------

-- ----------------------------
-- Table structure for sys_sms_template
-- ----------------------------
DROP TABLE IF EXISTS `sys_sms_template`;
CREATE TABLE `sys_sms_template`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `template_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板标题',
  `template_code` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '模板CODE',
  `template_type` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '模板类型：1短信 2邮件 3微信',
  `template_content` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '模板内容',
  `template_test_json` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板测试json',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建日期',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uniq_templatecode`(`template_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of sys_sms_template
-- ----------------------------
INSERT INTO `sys_sms_template` VALUES ('1', '系统消息通知', 'sys_ts_note', '4', '<h1>&nbsp; &nbsp; 系统通知</h1>\n<ul>\n<li>通知时间：&nbsp; ${ts_date}</li>\n<li>通知内容：&nbsp; ${ts_content}</li>\n</ul>', NULL, '2019-11-27 16:30:27', 'admin', '2019-11-27 19:36:50', 'admin');
INSERT INTO `sys_sms_template` VALUES ('2', '流程催办', 'bpm_cuiban', '4', '<h1>&nbsp; &nbsp;流程催办提醒</h1>\n<ul>\n<li>流程名称：&nbsp; ${bpm_name}</li>\n<li>催办任务：&nbsp; ${bpm_task}</li>\n<li>催办时间 :&nbsp; &nbsp; ${datetime}</li>\n<li>催办内容 :&nbsp; &nbsp; ${remark}</li>\n</ul>', NULL, '2019-11-27 17:08:12', 'admin', '2019-11-27 19:36:45', 'admin');
INSERT INTO `sys_sms_template` VALUES ('3', '流程办理超时提醒', 'bpm_chaoshi_tip', '4', '<h1>&nbsp; &nbsp;流程办理超时提醒</h1>\n<ul>\n<li>&nbsp; &nbsp;超时提醒信息：&nbsp; &nbsp; 您有待处理的超时任务，请尽快处理！</li>\n<li>&nbsp; &nbsp;超时任务标题：&nbsp; &nbsp; ${title}</li>\n<li>&nbsp; &nbsp;超时任务节点：&nbsp; &nbsp; ${task}</li>\n<li>&nbsp; &nbsp;任务处理人：&nbsp; &nbsp; &nbsp; &nbsp;${user}</li>\n<li>&nbsp; &nbsp;任务开始时间：&nbsp; &nbsp; ${time}</li>\n</ul>', NULL, '2019-11-27 19:19:24', 'admin', '2019-11-27 19:36:37', 'admin');
INSERT INTO `sys_sms_template` VALUES ('4', '请维护下商品单价', '11111', '4', '<p>请帮忙维护下商品单价</p>', NULL, '2020-11-18 17:18:58', 'admin', '2020-11-18 17:20:18', 'admin');
INSERT INTO `sys_sms_template` VALUES ('5', '催办：${taskName}', 'SYS001', '3', '${userName}，您好！\r\n请前待办任务办理事项！${taskName}\r\n\r\n\r\n===========================\r\n此消息由系统发出', '{\r\n\"taskName\":\"HR审批\",\r\n\"userName\":\"admin\"\r\n}', '2018-07-05 14:46:18', 'admin', '2018-07-05 18:31:34', 'admin');

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user`  (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `username` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '账号',
  `realname` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '真名',
  `password` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '密码',
  `create_Date` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `last_Login_Time` date NULL DEFAULT NULL COMMENT '最后登录时间',
  `enabled` int NULL DEFAULT 0,
  `account_Non_Expired` int NULL DEFAULT 0,
  `account_Non_Locked` int NULL DEFAULT 0,
  `credentials_Non_Expired` int NULL DEFAULT 0,
  `Fmodify_date` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新人',
  `fdate` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `fcreator` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `idx_account_username`(`username`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES (1, 'admin', '张三', '$2a$10$6Lx/bmiLraMqI/MwE3d0y.B7fMjNkS2mN4M8o9sANbxCOw2Js2hiq', '2021-11-13 00:00:00', '2022-03-01', 1, 1, 1, 1, '2022-03-31 17:21:29', '', '2022-03-31 17:21:29', '');

-- ----------------------------
-- Table structure for sys_user_depart
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_depart`;
CREATE TABLE `sys_user_depart`  (
  `ID` bigint NOT NULL COMMENT 'id',
  `user_id` bigint NULL DEFAULT NULL COMMENT '用户id',
  `dep_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门id',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `index_depart_groupk_userid`(`user_id`) USING BTREE,
  INDEX `index_depart_groupkorgid`(`dep_id`) USING BTREE,
  INDEX `index_depart_groupk_uidanddid`(`user_id`, `dep_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of sys_user_depart
-- ----------------------------

-- ----------------------------
-- Table structure for sys_user_message
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_message`;
CREATE TABLE `sys_user_message`  (
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户名',
  `avatar` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71' COMMENT '头像url',
  `introduction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户介绍',
  `fauth_account` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '账号',
  `fenglish_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '英文名称',
  `fwork_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工号',
  `fdept` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '部门',
  `fphone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '手机',
  `fmail` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  `fwork_addr` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工作地点',
  `fposition` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '职位',
  `finduction_date` datetime(0) NULL DEFAULT NULL COMMENT '入职日期',
  `fstate` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '状态',
  `fdate` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建日期',
  `fcreator` varchar(67) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`user_id`) USING BTREE,
  UNIQUE INDEX `idx_auth_account`(`fauth_account`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_message
-- ----------------------------
INSERT INTO `sys_user_message` VALUES (1, '张三', 'https://ss0.baidu.com/94o3dSag_xI4khGko9WTAnF6hhy/baike/s=220/sign=92f3220861d0f703e2b292de38fb5148/37d3d539b6003af32267a87f362ac65c1138b6cb.jpg', '', 'admin', 'admin', '114514', '', '', '114514@homo.com', '123', '', '2022-04-12 00:00:00', '困', '2022-04-02 00:00:00', '');

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role`  (
  `user_id` bigint NULL DEFAULT NULL,
  `role_id` bigint NULL DEFAULT NULL,
  `Fmodify_date` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新人',
  `fdate` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `fcreator` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建人',
  INDEX `FK_Reference_1`(`user_id`) USING BTREE,
  INDEX `role_id`(`role_id`) USING BTREE,
  CONSTRAINT `FK_Reference_1` FOREIGN KEY (`user_id`) REFERENCES `sys_user` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `sys_user_role_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
INSERT INTO `sys_user_role` VALUES (1, 1, '2022-06-08 14:22:02', '', '2022-06-08 14:22:02', '');

-- ----------------------------
-- Table structure for t_schedule_trigger
-- ----------------------------
DROP TABLE IF EXISTS `t_schedule_trigger`;
CREATE TABLE `t_schedule_trigger`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `cron` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `job_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `job_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `job_name`(`job_name`, `job_group`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of t_schedule_trigger
-- ----------------------------

-- ----------------------------
-- Table structure for t_schedule_trigger_param
-- ----------------------------
DROP TABLE IF EXISTS `t_schedule_trigger_param`;
CREATE TABLE `t_schedule_trigger_param`  (
  `param_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `value` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `schedule_trigger_id` int NOT NULL,
  PRIMARY KEY (`param_id`) USING BTREE,
  INDEX `schedule_trigger_id`(`schedule_trigger_id`) USING BTREE,
  CONSTRAINT `t_schedule_trigger_param_ibfk_1` FOREIGN KEY (`schedule_trigger_id`) REFERENCES `t_schedule_trigger` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of t_schedule_trigger_param
-- ----------------------------

-- ----------------------------
-- Table structure for tb_form_table_structure
-- ----------------------------
DROP TABLE IF EXISTS `tb_form_table_structure`;
CREATE TABLE `tb_form_table_structure`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `form_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '表单标识',
  `db_table_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '数据库表名',
  `db_table_comment` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '数据库表注释',
  `form_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '前端表单Json',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '表单表结构表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of tb_form_table_structure
-- ----------------------------

-- ----------------------------
-- Table structure for tb_init_connect_param
-- ----------------------------
DROP TABLE IF EXISTS `tb_init_connect_param`;
CREATE TABLE `tb_init_connect_param`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `k3_cloud_url` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '金蝶地址',
  `dbid` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '金蝶账套',
  `uid` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户名',
  `pwd` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '密码',
  `lang` int NOT NULL COMMENT '端口',
  `is_auto_submit` tinyint(1) NOT NULL DEFAULT 1 COMMENT '是否提交审核',
  `third_party_url` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '第三方路径',
  `duration` int NULL DEFAULT 1 COMMENT '定时任务时长/分钟',
  `lic_cipher_text` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'lic密文',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '金蝶配置表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of tb_init_connect_param
-- ----------------------------
INSERT INTO `tb_init_connect_param` VALUES (1, 'https://basicsemi.test.ik3cloud.com/k3cloud/', '20210526143523305', 'Administrator', 'Qtj@2022', 2052, 0, 'http://192.168.50.213:8050/api/updateImsData', 1, NULL, '2022-07-20 11:35:18', '2022-08-17 00:00:24');

-- ----------------------------
-- Table structure for tb_kingdee_common_config
-- ----------------------------
DROP TABLE IF EXISTS `tb_kingdee_common_config`;
CREATE TABLE `tb_kingdee_common_config`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `s_form_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '金蝶标识',
  `doc_type` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '第三方标识',
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '日志名称',
  `flag` tinyint NOT NULL COMMENT '配置方向（-1-ERP/MES 1-MES/ERP）',
  `primary_key_field` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据主键字段',
  `entry_primary_key_field` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据分录主键字段',
  `mes_entry_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'MES分录标识',
  `entry_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分录标识',
  `fathers_form_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '源单标识',
  `father_entry_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '源单分录标识',
  `push_rule` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '下推规则',
  `link_fs_id_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '子源单行内码',
  `is_in_transaction` tinyint(1) NULL DEFAULT NULL COMMENT '是否在事务中',
  `is_auto_perform` tinyint(1) NULL DEFAULT 3 COMMENT '执行步骤（0-暂存，1-保存，2-提交，3-审核）',
  `kingdee_filed_detail` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '金蝶字段相关明细',
  `plug_in_url` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '插件地址',
  `custom_sql` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '自定义Sql',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 43 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '金蝶通用配置表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of tb_kingdee_common_config
-- ----------------------------
INSERT INTO `tb_kingdee_common_config` VALUES (1, 'BD_Supplier', 'BS_SUP', '供应商', -1, 'FSupplierId', '', 'bs_sup_dt', '', '', '', '', '', 1, 3, '[{\"isDetailField\":false,\"erpName\":\"编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"供应商编码\",\"thirdPartyField\":\"sup_code\"},{\"isDetailField\":false,\"erpName\":\"名称\",\"kingdeeField\":\"FName\",\"type\":\"文本\",\"mesName\":\"供应商名称\",\"thirdPartyField\":\"sup_name\"},{\"isDetailField\":false,\"erpName\":\"国家\",\"kingdeeField\":\"FCountry\",\"type\":\"文本\",\"mesName\":\"国家编码\",\"thirdPartyField\":\"country_code\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"type\":\"文本\",\"mesName\":\"禁用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":true,\"erpName\":\"联系人\",\"kingdeeField\":\"FContact\",\"type\":\"文本\",\"mesName\":\"联系人\",\"thirdPartyField\":\"contacts_user\"},{\"isDetailField\":true,\"erpName\":\"电话\",\"kingdeeField\":\"FTel\",\"type\":\"数值\",\"mesName\":\"联系电话\",\"thirdPartyField\":\"contacts_phone\"},{\"isDetailField\":true,\"erpName\":\"默认联系人\",\"kingdeeField\":\"FContactIsDefault\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"默认联系人\",\"thirdPartyField\":\"FContactIsDefault\"}]', '', '', '2022-08-03 09:23:03', '2022-10-27 17:33:47');
INSERT INTO `tb_kingdee_common_config` VALUES (2, 'BD_Customer', 'BS_CUST', '客户', -1, 'FCUSTID', NULL, '', '', '', '', '', '', 1, 3, '[{\"isDetailField\":false,\"erpName\":\"客户编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"客户编码\",\"thirdPartyField\":\"cust_code\"},{\"isDetailField\":false,\"erpName\":\"客户名称\",\"kingdeeField\":\"FName\",\"type\":\"文本\",\"mesName\":\"客户名称\",\"thirdPartyField\":\"cust_name\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"type\":\"文本\",\"mesName\":\"禁用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":false,\"erpName\":\"备注\",\"kingdeeField\":\"FDescription\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"remark\"}]', '', '', '2022-08-03 09:57:34', '2022-08-30 17:45:59');
INSERT INTO `tb_kingdee_common_config` VALUES (4, 'BD_STOCK', 'BS_STORE', '仓库', -1, 'FStockId', NULL, '', '', '', '', '', '', 1, 3, '[{\"isDetailField\":false,\"erpName\":\"编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"store_code\"},{\"isDetailField\":false,\"erpName\":\"名称\",\"kingdeeField\":\"FName\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"仓库名称\",\"thirdPartyField\":\"store_name\"},{\"isDetailField\":false,\"erpName\":\"库存状态类型\",\"kingdeeField\":\"FStockStatusType\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"仓库类型\",\"thirdPartyField\":\"store_type\"}]', '', '', '2022-08-03 09:59:00', '2022-08-30 17:46:00');
INSERT INTO `tb_kingdee_common_config` VALUES (5, 'BD_MATERIAL', 'BS_MTRL', '物料', -1, 'FMATERIALID', NULL, '', '', '', '', '', '', 1, 3, '[{\"isDetailField\":false,\"erpName\":\"物料编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"集团编码\",\"thirdPartyField\":\"group_code\"},{\"isDetailField\":false,\"erpName\":\"物料编码\",\"kingdeeField\":\"FOldNumber\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"mtrl_code\"},{\"isDetailField\":false,\"erpName\":\"名称\",\"kingdeeField\":\"FName\",\"type\":\"文本\",\"mesName\":\"物料名称\",\"thirdPartyField\":\"mtrl_name\"},{\"isDetailField\":false,\"erpName\":\"规格型号\",\"kingdeeField\":\"FSpecification\",\"type\":\"文本\",\"mesName\":\"物料规格\",\"thirdPartyField\":\"mtrl_desc\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"type\":\"文本\",\"mesName\":\"禁用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":false,\"erpName\":\"最小包装数\",\"kingdeeField\":\"FMinPackCount\",\"type\":\"数值\",\"mesName\":\"最小包装数\",\"thirdPartyField\":\"pack_qty\"},{\"isDetailField\":false,\"erpName\":\"基本单位\",\"kingdeeField\":\"FBaseUnitId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"单位\",\"thirdPartyField\":\"munit\"},{\"isDetailField\":false,\"erpName\":\"物料状态\",\"kingdeeField\":\"F_ora_Assistant\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料状态\",\"thirdPartyField\":\"mtrl_status\"},{\"isDetailField\":false,\"erpName\":\"组织\",\"kingdeeField\":\"FUseOrgId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"组织代码\",\"thirdPartyField\":\"org_id\"}]', '', '', '2022-08-03 11:39:26', '2022-08-30 17:46:01');
INSERT INTO `tb_kingdee_common_config` VALUES (6, 'ENG_BOM', 'BS_BOM', '物料清单', -1, 'FID', NULL, 'bs_bom_mtrl', '', '', '', '', '', 1, 3, '[{\"isDetailField\":false,\"erpName\":\"父项集团编码\",\"kingdeeField\":\"FMATERIALID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"父项集团编码\",\"thirdPartyField\":\"prod_code\"},{\"isDetailField\":false,\"erpName\":\"父项公司编码\",\"kingdeeField\":\"F_ora_BaseProperty1\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"父项物料编码\",\"thirdPartyField\":\"fprod_code\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"启用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":true,\"erpName\":\"子项物料编码\",\"kingdeeField\":\"FMATERIALIDCHILD\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\" mtrl_code\"},{\"isDetailField\":true,\"erpName\":\"公司物料编码\",\"kingdeeField\":\"F_ora_BaseProperty2\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"子项MES物料编码\",\"thirdPartyField\":\"mes_mtrl_code\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FMEMO\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"remark\"},{\"isDetailField\":true,\"erpName\":\"是否主料\",\"kingdeeField\":\"FIskeyItem\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"是否主料\",\"thirdPartyField\":\"is_main\"},{\"isDetailField\":true,\"erpName\":\"用量分母\",\"kingdeeField\":\"FDENOMINATOR\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"用量分母\",\"thirdPartyField\":\"dosage\"},{\"isDetailField\":true,\"erpName\":\"点位\",\"kingdeeField\":\"FPOSITIONNO\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"点位\",\"thirdPartyField\":\"point_str\"},{\"isDetailField\":true,\"erpName\":\"主料编码\",\"kingdeeField\":\"main_code\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"主料编码\",\"thirdPartyField\":\"main_code\"},{\"isDetailField\":true,\"erpName\":\"层级\",\"kingdeeField\":\"Lev\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"层级\",\"thirdPartyField\":\"Lev\"}]', 'http://192.168.50.211:9090/semiconductor/api/materials/list/plug', '/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,a.FREPLACEGROUP as xc,\n1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=@FID) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,c.FREPLACEGROUP  as xc,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  ,a.FREPLACEGROUP \n from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,\nstepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z order by Lev,FSEQ,xc', '2022-08-03 11:41:54', '2022-10-13 17:07:00');
INSERT INTO `tb_kingdee_common_config` VALUES (7, 'PUR_PurchaseOrder', 'SM_PO', '采购订单', -1, 'FID', '', 'sm_po_dt', '', '', '', '', '', 1, 3, '[{\"isDetailField\":false,\"erpName\":\"单据编号\",\"kingdeeField\":\"FBillNo\",\"type\":\"FNumber\",\"mesName\":\"采购订单编码\",\"thirdPartyField\":\"po_code\"},{\"isDetailField\":false,\"erpName\":\"采购日期\",\"kingdeeField\":\"FDate\",\"type\":\"文本\",\"mesName\":\"日期\",\"thirdPartyField\":\"indate\"},{\"isDetailField\":false,\"erpName\":\"供应商\",\"kingdeeField\":\"FSupplierId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"供应商编码\",\"thirdPartyField\":\"sup_code\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"集团编码\",\"thirdPartyField\":\"mtrl_code\"},{\"isDetailField\":true,\"erpName\":\"采购数量\",\"kingdeeField\":\"FQty\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"m_qty\"},{\"isDetailField\":true,\"erpName\":\"数量\",\"kingdeeField\":\"FPlanQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"交货数量\",\"thirdPartyField\":\"ro_qty\"},{\"isDetailField\":true,\"erpName\":\"采购单位\",\"kingdeeField\":\"FUnitID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"采购单位\",\"thirdPartyField\":\"po_unit\"},{\"isDetailField\":true,\"erpName\":\"税额\",\"kingdeeField\":\"FEntryTaxAmount\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"税额\",\"thirdPartyField\":\"tax\"},{\"isDetailField\":true,\"erpName\":\"价税合计\",\"kingdeeField\":\"FAllAmount\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"价税合计\",\"thirdPartyField\":\"totalmoney\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntryNote\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"remark\"},{\"isDetailField\":true,\"erpName\":\"分录主键\",\"kingdeeField\":\"FPOOrderEntry_FEntryID\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"ERP行内码\",\"thirdPartyField\":\"ERP_SIC\"},{\"isDetailField\":true,\"erpName\":\"规格型号\",\"kingdeeField\":\"FModel\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料规格\",\"thirdPartyField\":\"po_mtrl_descs\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"F_ora_BaseProperty\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"ma_code\"},{\"isDetailField\":true,\"erpName\":\"业务关闭\",\"kingdeeField\":\"FMRPCloseStatus\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"业务关闭\",\"thirdPartyField\":\"CloseStatus\"},{\"isDetailField\":true,\"erpName\":\"关闭状态\",\"kingdeeField\":\"FCloseStatus\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"订单关闭状态\",\"thirdPartyField\":\"FCloseStatus\"}]', '', '', '2022-08-03 12:00:05', '2022-10-27 17:36:18');
INSERT INTO `tb_kingdee_common_config` VALUES (10, 'STK_MisDelivery', 'BS0043', '其他出库', -1, 'FID', NULL, '', '', '', '', '', '', 1, 3, '[{\"isDetailField\":true,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"发货仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"实发数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"其他出库单号\",\"thirdPartyField\":\"REF_TRX_CODE\"}]', '', '', '2022-08-03 17:10:19', '2022-08-30 17:46:02');
INSERT INTO `tb_kingdee_common_config` VALUES (11, 'PRD_PPBOM', 'WMS0004', '生产用料清单', 1, '', NULL, '', 'FEntity', '', '', '', '', 1, 2, '[{\"isDetailField\":true,\"erpName\":\"货主类型\",\"kingdeeField\":\"FOwnerTypeId\",\"indexField\":\"\",\"type\":\"基础资料\",\"mesName\":\"货主类型\",\"thirdPartyField\":\"SHIPPER_TYPE\"},{\"isDetailField\":true,\"erpName\":\"货主\",\"kingdeeField\":\"FOwnerID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"货主\",\"thirdPartyField\":\"SHIPPER_ID\"},{\"isDetailField\":true,\"erpName\":\"子项物料编码\",\"kingdeeField\":\"FMaterialID2\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"标准用量\",\"kingdeeField\":\"FStdQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"用量\",\"thirdPartyField\":\"DOSAGE\"},{\"isDetailField\":true,\"erpName\":\"需求数量\",\"kingdeeField\":\"FNeedQty2\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"净需求数量\",\"thirdPartyField\":\"NN_QTY\"},{\"isDetailField\":true,\"erpName\":\"应发数量\",\"kingdeeField\":\"FMustQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"实际需求数量\",\"thirdPartyField\":\"TN_QTY\"},{\"isDetailField\":true,\"erpName\":\"位置号\",\"kingdeeField\":\"FPositionNO\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"位置号\",\"thirdPartyField\":\"POINT_STR\"},{\"isDetailField\":false,\"erpName\":\"数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"计划数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"生产订单编号\",\"kingdeeField\":\"FMOBillNO1\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"生产订单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"行内码\",\"kingdeeField\":\"FEntryID\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"行内码\",\"thirdPartyField\":\"ERP_SIC\"},{\"isDetailField\":false,\"erpName\":\"主键\",\"kingdeeField\":\"FID\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"主键\",\"thirdPartyField\":\"ERP_FID\"},{\"isDetailField\":false,\"erpName\":\"生产订单行号\",\"kingdeeField\":\"FMoEntrySeq1\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"生产订单行号\",\"thirdPartyField\":\"MO_SEQ\"},{\"isDetailField\":true,\"erpName\":\"MES主键\",\"kingdeeField\":\"F_LQKJ_Code\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"MES主键\",\"thirdPartyField\":\"MES_CODE\"}]', 'http://192.168.50.211:9090/semiconductor/api/production/material/list/plug', '', '2022-08-03 17:25:24', '2022-10-19 17:14:19');
INSERT INTO `tb_kingdee_common_config` VALUES (12, 'PRD_MO', 'WMS0002', '生产订单', 1, '', NULL, '', 'FTreeEntity', '', '1', '', '', 1, 2, '[{\"isDetailField\":false,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"生产订单编号\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"集团编码\",\"thirdPartyField\":\"GROUP_ID\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"计划开工时间\",\"kingdeeField\":\"FPlanStartDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"计划开始时间\",\"thirdPartyField\":\"PB_DATE\"},{\"isDetailField\":true,\"erpName\":\"计划完工时间\",\"kingdeeField\":\"FPlanFinishDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"计划结束时间\",\"thirdPartyField\":\"PE_DATE\"},{\"isDetailField\":false,\"erpName\":\"单据日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"单据日期\",\"thirdPartyField\":\"PRD_DATE\"},{\"isDetailField\":true,\"erpName\":\"单位\",\"kingdeeField\":\"FUnitId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"单位\",\"thirdPartyField\":\"MUNIT\"},{\"isDetailField\":true,\"erpName\":\"生产车间\",\"kingdeeField\":\"FWorkShopID\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"生产车间\",\"thirdPartyField\":\"FWorkShopID\"},{\"isDetailField\":false,\"erpName\":\"基本单位数量\",\"kingdeeField\":\"FBaseSNQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"基本单位数量\",\"thirdPartyField\":\"FBaseSNQty\"},{\"isDetailField\":true,\"erpName\":\"MES主键\",\"kingdeeField\":\"F_LQKJ_Code\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"MES主键\",\"thirdPartyField\":\"MES_CODE\"}]', '', '', '2022-08-03 17:54:41', '2022-10-19 17:14:33');
INSERT INTO `tb_kingdee_common_config` VALUES (13, 'PRD_PickMtrl', 'WMS0003', '生产领料单', 1, '', NULL, '', 'FEntity', 'PRD_PPBOM', 'FEntity', 'PRD_IssueMtrl2PickMtrl', 'ERP_SIC', 1, 2, '[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"实发数量\",\"kingdeeField\":\"FActualQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntrtyMemo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"},{\"isDetailField\":true,\"erpName\":\"工单编码\",\"kingdeeField\":\"FEntrySrcBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"}]', 'http://192.168.50.211:9090/semiconductor/api/production/picking/plug', '', '2022-08-03 18:15:17', '2022-10-19 17:15:11');
INSERT INTO `tb_kingdee_common_config` VALUES (14, 'PRD_FeedMtrl', 'BS0040', '生产补料单', 1, '', NULL, '', 'FEntity', 'PRD_PPBOM', 'FEntity', 'PRD_PPBOM2FEEDMTRL', 'ERP_SIC', 1, 2, '[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实发数量\",\"kingdeeField\":\"FActualQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntrtyDescription\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"},{\"isDetailField\":true,\"erpName\":\"工单编码\",\"kingdeeField\":\"FEntrySrcBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"申请数量\",\"kingdeeField\":\"FAppQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"申请数量\",\"thirdPartyField\":\"QUANTITY\"}]', 'http://192.168.50.211:9090/semiconductor/api/production/picking/plug', '', '2022-08-03 18:21:58', '2022-10-19 17:15:21');
INSERT INTO `tb_kingdee_common_config` VALUES (15, 'PRD_ReturnMtrl', 'BS0050', '生产退料单', 1, '', NULL, '', 'FEntity', 'PRD_PPBOM', 'FEntity', 'PRD_PPBOM2RETURNMTRL', 'ERP_SIC', 1, 2, '[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实退数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"系统源单编码\",\"kingdeeField\":\"FSrcBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntrtyMemo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"}]', 'http://192.168.50.211:9090/semiconductor/api/production/picking/plug', '', '2022-08-03 18:26:16', '2022-10-19 17:15:27');
INSERT INTO `tb_kingdee_common_config` VALUES (16, 'PRD_MO', 'BS0057', '生产订单关闭', 1, '', NULL, '', 'FEntryId', '', '', '', '', 1, 3, '[{\"isDetailField\":false,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"MES状态\",\"kingdeeField\":\"F_LQKJ_MESStates\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"MES状态\",\"thirdPartyField\":\"F_LQKJ_MESStates\"}]', '', 'UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = @MES_CODE', '2022-08-03 18:31:01', '2022-08-30 17:46:04');
INSERT INTO `tb_kingdee_common_config` VALUES (17, 'PRD_INSTOCK', 'BS0055', '生产入库单', 1, '', NULL, '', 'FEntity', 'PRD_MO', 'FTreeEntity', 'PRD_MO2INSTOCK', 'ERP_SIC', 1, 2, '[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"生产订单编码\",\"kingdeeField\":\"FMoBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"ERP_MO\"},{\"isDetailField\":true,\"erpName\":\"生产订单行号\",\"kingdeeField\":\"FMoEntrySeq\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"生产订单行号\",\"thirdPartyField\":\"ERP_SEQ\"},{\"isDetailField\":true,\"erpName\":\"实收数量\",\"kingdeeField\":\"FRealQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"入库组织\",\"kingdeeField\":\"FStockOrgId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"入库组织\",\"thirdPartyField\":\"ORG_ID\"},{\"isDetailField\":false,\"erpName\":\"仓管员\",\"kingdeeField\":\"FStockerId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓管员\",\"thirdPartyField\":\"USER_CODE\"}]', 'http://192.168.50.211:9090/semiconductor/api/production/warehousing/plug', '', '2022-08-03 18:37:47', '2022-10-21 11:17:33');
INSERT INTO `tb_kingdee_common_config` VALUES (18, 'STK_OEMInStock', 'BS0004', '受托加工材料入库单', 1, '', NULL, '', 'FBillEntry', '', '', '', '', 1, 2, '[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":true,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":false,\"erpName\":\"客户\",\"kingdeeField\":\"FCustId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"客户编码\",\"thirdPartyField\":\"CUST_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"收货仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实收数量(基本单位)\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"库存状态\",\"kingdeeField\":\"FStockStatusId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"库存状态\",\"thirdPartyField\":\"STOCK_TYPE\"}]', '', '', '2022-08-03 18:42:44', '2022-10-19 17:15:46');
INSERT INTO `tb_kingdee_common_config` VALUES (19, 'STK_InStock', 'WMS0012', '采购入库单', 1, '', '', '', 'FInStockEntry', 'PUR_PurchaseOrder', 'FPOOrderEntry', 'PUR_PurchaseOrder-STK_InStock', 'ERP_SIC', 1, 2, '[{\"isDetailField\":false,\"erpName\":\"入库日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实收数量\",\"kingdeeField\":\"FRealQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"源单编码\",\"kingdeeField\":\"FSRCBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"采购单号\",\"thirdPartyField\":\"PO_CODE\"},{\"isDetailField\":true,\"erpName\":\"行号\",\"kingdeeField\":\"FSeq\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"采购行号\",\"thirdPartyField\":\"PO_SEQ\"},{\"isDetailField\":false,\"erpName\":\"收料部门\",\"kingdeeField\":\"FSTOCKDEPTID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"收料部门\",\"thirdPartyField\":\"STOCKDEP\"},{\"isDetailField\":false,\"erpName\":\"仓管员\",\"kingdeeField\":\"FSTOCKERID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓管员\",\"thirdPartyField\":\"STOCKUSER\"}]', '', '', '2022-08-03 18:49:25', '2022-10-27 15:51:26');
INSERT INTO `tb_kingdee_common_config` VALUES (20, 'PUR_MRB', 'BS0045', '采购退料单', 1, '', NULL, '', 'FPURMRBENTRY', 'PUR_PurchaseOrder', 'FPOOrderEntry', 'PUR_PurchaseOrder-PUR_MRB', 'ERP_SIC', 1, 2, '[{\"isDetailField\":false,\"erpName\":\"退料日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"实退数量\",\"kingdeeField\":\"FRMREALQTY\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"退料类型\",\"kingdeeField\":\"FMRTYPE\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"退料类型\",\"thirdPartyField\":\"FMRTYPE1\"},{\"isDetailField\":true,\"erpName\":\"仓库编码\",\"kingdeeField\":\"FSTOCKID\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"源单编码\",\"kingdeeField\":\"FSRCBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"采购入库单号\",\"thirdPartyField\":\"PO_CODE\"},{\"isDetailField\":true,\"erpName\":\"行号\",\"kingdeeField\":\"FSeq\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"采购入库单行号\",\"thirdPartyField\":\"PO_SEQ\"}]', '', '', '2022-08-03 18:55:10', '2022-10-19 17:16:04');
INSERT INTO `tb_kingdee_common_config` VALUES (21, 'STK_MISCELLANEOUS', 'BS0022', '其他入库', 1, '', NULL, '', 'FEntity', '', '', '', '', 1, 3, '[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"供应商\",\"kingdeeField\":\"FSUPPLIERID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"供应商编码\",\"thirdPartyField\":\"SUP_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMATERIALID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":false,\"erpName\":\"库存组织\",\"kingdeeField\":\"FStockOrgId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"库存组织\",\"thirdPartyField\":\"ORG_ID\"},{\"isDetailField\":false,\"erpName\":\"仓管员\",\"kingdeeField\":\"FSTOCKERID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓管员\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"实收数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"实收数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"收货仓库\",\"kingdeeField\":\"FSTOCKID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"收货仓库\",\"thirdPartyField\":\"STORE_CODE\"}]', '', '', '2022-08-03 19:00:38', '2022-08-30 17:46:07');
INSERT INTO `tb_kingdee_common_config` VALUES (22, 'STK_StockCountGain', 'BS0028', '盘点盘盈单', -1, 'FID', NULL, '', 'FBillEntry', '', '', '', '', 1, 3, '[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"盘点数量\",\"kingdeeField\":\"FCountQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"库存组织\",\"kingdeeField\":\"FStockOrgId\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"组织\",\"thirdPartyField\":\"ORG_ID\"},{\"isDetailField\":false,\"erpName\":\"备注\",\"kingdeeField\":\"FNoteHead\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"}]', '', '', '2022-08-03 19:05:00', '2022-08-30 17:46:07');
INSERT INTO `tb_kingdee_common_config` VALUES (23, 'STK_StockCountLoss', 'BS0029', '盘点盘亏单', -1, 'FID', NULL, '', 'FBillEntry', '', '', '', '', 1, 3, '[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"盘点数量\",\"kingdeeField\":\"FCountQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"}]', '', '', '2022-08-03 19:10:16', '2022-08-30 17:46:08');
INSERT INTO `tb_kingdee_common_config` VALUES (24, 'STK_TransferDirect', 'BS0030', '直接调拨单', 1, '', NULL, '', 'FBillEntry', '', '', '', '', 1, 2, '[{\"isDetailField\":false,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"直接调拨单编码\",\"thirdPartyField\":\"FBillNo\"},{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"调出仓库\",\"kingdeeField\":\"FSrcStockId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"调出仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"调拨数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"调入仓库\",\"kingdeeField\":\"FDestStockId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"调入仓库编码\",\"thirdPartyField\":\"TO_STORE_CODE\"},{\"isDetailField\":false,\"erpName\":\"调出货主类型\",\"kingdeeField\":\"FOwnerTypeOutIdHead\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"调出货主类型\",\"thirdPartyField\":\"SHIPPER_TYPE\"},{\"isDetailField\":false,\"erpName\":\"调出货主\",\"kingdeeField\":\"FOwnerOutIdHead\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"调出货主\",\"thirdPartyField\":\"SHIPPER_ID\"},{\"isDetailField\":false,\"erpName\":\"申请人\",\"kingdeeField\":\"F_ora_Base\",\"indexField\":\"FStaffNumber\",\"type\":\"基础资料\",\"mesName\":\"申请人\",\"thirdPartyField\":\"F_ora_Base\"}]', '', '', '2022-08-03 19:16:51', '2022-10-08 14:48:57');

-- ----------------------------
-- Table structure for tb_kingdee_log
-- ----------------------------
DROP TABLE IF EXISTS `tb_kingdee_log`;
CREATE TABLE `tb_kingdee_log`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '业务名称',
  `queue_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '唯一标识',
  `request` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '请求参数',
  `flag` tinyint(1) NULL DEFAULT 1 COMMENT '是否成功（0-失败，1-成功）',
  `response` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '响应信息',
  `message` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '错误原因',
  `cost_time` int NULL DEFAULT 0 COMMENT '耗时（毫秒）',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_queue_id`(`queue_id`) USING BTREE,
  INDEX `index_create_time`(`create_time`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3071 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '金蝶日志记录表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of tb_kingdee_log
-- ----------------------------

-- ----------------------------
-- Table structure for tb_quartz_job
-- ----------------------------
DROP TABLE IF EXISTS `tb_quartz_job`;
CREATE TABLE `tb_quartz_job`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `job_class_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '任务类名',
  `cron_expression` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'cron表达式',
  `parameter` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '参数',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '状态（0-关闭 1-启动）',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '定时任务表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of tb_quartz_job
-- ----------------------------
INSERT INTO `tb_quartz_job` VALUES (1, 'com.system.quartz.job.SynchronizationJob', '0 */1  * * * ?', '', '同步定时任务', 1, '2022-07-19 11:05:44', '2022-10-27 14:43:20');

-- ----------------------------
-- Table structure for tb_synchronization_record
-- ----------------------------
DROP TABLE IF EXISTS `tb_synchronization_record`;
CREATE TABLE `tb_synchronization_record`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `fid` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '同步记录主键',
  `data_id` int NOT NULL COMMENT '同步记录数据内码',
  `entry_id` int NULL DEFAULT NULL COMMENT '同步记录数据分录内码',
  `s_form_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '金蝶标识',
  `queue_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '唯一标识',
  `message` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '错误原因',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '同步状态（0-未同步，1-同步中，2-同步失败，3-同步成功）',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `index_fid`(`fid`) USING BTREE,
  INDEX `index_status`(`status`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1252 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '金蝶同步记录表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of tb_synchronization_record
-- ----------------------------

-- ----------------------------
-- Table structure for tb_synchronization_record_temp
-- ----------------------------
DROP TABLE IF EXISTS `tb_synchronization_record_temp`;
CREATE TABLE `tb_synchronization_record_temp`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `fid` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '同步记录主键',
  `data_id` int NOT NULL COMMENT '同步记录数据内码',
  `entry_id` int NULL DEFAULT NULL COMMENT '同步记录数据分录内码',
  `s_form_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '金蝶标识',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `index_fid`(`fid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1252 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '金蝶同步记录临时表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of tb_synchronization_record_temp
-- ----------------------------

-- ----------------------------
-- Table structure for tb_third_party_log
-- ----------------------------
DROP TABLE IF EXISTS `tb_third_party_log`;
CREATE TABLE `tb_third_party_log`  (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '业务名称',
  `code` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '业务标识',
  `queue_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '唯一标识',
  `request` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '请求参数',
  `flag` tinyint(1) NULL DEFAULT 1 COMMENT '是否成功（0-失败，1-成功）',
  `response` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '响应信息',
  `message` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '错误原因',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_queue_id`(`queue_id`) USING BTREE,
  INDEX `index_create_time`(`create_time`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2762 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '第三方日志记录表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of tb_third_party_log
-- ----------------------------

-- ----------------------------
-- Table structure for undo_log
-- ----------------------------
DROP TABLE IF EXISTS `undo_log`;
CREATE TABLE `undo_log`  (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `branch_id` bigint NOT NULL,
  `xid` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `context` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `rollback_info` longblob NOT NULL,
  `log_status` int NOT NULL,
  `log_created` datetime(0) NOT NULL,
  `log_modified` datetime(0) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `ux_undo_log`(`xid`, `branch_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of undo_log
-- ----------------------------

SET FOREIGN_KEY_CHECKS = 1;
