package com.system.controller;

import com.system.serivce.IKingDeeCommonConfigService;
import com.system.transfer.kingdee.*;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "金蝶通用配置")
@RestController
@RequestMapping("/api")
public class KingDeeCommonConfigController {

    @Autowired
    private IKingDeeCommonConfigService kingDeeCommonConfigService;


    @ApiOperation("金蝶通用配置列表")
    @GetMapping("/kingdee/common/config/list")
    public RestResponse kingDeeCommonConfigList(@ModelAttribute KingDeeCommonConfigListInVo inVo) {
        KingdeeCommonConfigListOutVo outVo = kingDeeCommonConfigService.kingDeeCommonConfigList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("金蝶通用配置创建")
    @PostMapping("/kingdee/common/config/create")
    public RestResponse kingDeeCommonConfigCreate(@RequestBody KingdeeCommonConfigCreateInVo inVo) {
        return kingDeeCommonConfigService.kingDeeCommonConfigCreate(inVo);
    }

    @ApiOperation("金蝶通用配置更新")
    @PutMapping("/kingdee/common/config/update")
    public RestResponse kingDeeCommonConfigUpdate(@RequestBody KingdeeCommonConfigUpdateInVo inVo) {
        return kingDeeCommonConfigService.kingDeeCommonConfigUpdate(inVo);
    }

    @ApiOperation("金蝶通用配置删除")
    @DeleteMapping("/kingdee/common/config/delete")
    public RestResponse kingDeeCommonConfigDelete(@ModelAttribute KingdeeCommonConfigDeleteInVo inVo) {
        return kingDeeCommonConfigService.kingDeeCommonConfigDelete(inVo);
    }


}
