package com.system.quartz.controller;

import com.system.transfer.response.RestResponse;
import com.system.quartz.service.IQuartzJobService;
import com.system.quartz.transfer.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "定时任务")
@RestController
@RequestMapping("/api")
public class QuartzJobController {

    @Autowired
    private IQuartzJobService quartzJobService;


    @ApiOperation("定时任务列表")
    @GetMapping(value = "/quartz/job/list")
    public RestResponse quartzJobList(@ModelAttribute @Validated QuartzJobListInVo inVo) {
        QuartzJobListOutVo outVo = quartzJobService.quartzJobList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("定时任务创建")
    @PostMapping(value = "/quartz/job/create")
    public RestResponse quartzJobCreate(@RequestBody @Validated QuartzJobCreateInVo inVo) {
        return quartzJobService.quartzJobCreate(inVo);
    }

    @ApiOperation("定时任务编辑")
    @PutMapping(value = "/quartz/job/update")
    public RestResponse quartzJobUpdate(@RequestBody @Validated QuartzJobUpdateInVo inVo) {
        return quartzJobService.quartzJobUpdate(inVo);
    }

    @ApiOperation("定时任务删除")
    @DeleteMapping(value = "/quartz/job/delete")
    public RestResponse quartzJobDelete(@ModelAttribute @Validated QuartzJobDeleteInVo inVo) {
        return quartzJobService.quartzJobDelete(inVo);
    }

    @ApiOperation("定时任务启动")
    @GetMapping(value = "/quartz/job/resume")
    public RestResponse quartzJobResume(@ModelAttribute @Validated QuartzJobResumeInVo inVo) {
        return quartzJobService.quartzJobResume(inVo);
    }

    @ApiOperation("定时任务暂停")
    @GetMapping(value = "/quartz/job/pause")
    public RestResponse quartzJobPause(@ModelAttribute @Validated QuartzJobPauseInVo inVo) {
        return quartzJobService.quartzJobPause(inVo);
    }


}
