package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.constants.KingDeeCommonPushConstants;
import com.system.constants.KingDeeCommonSynConstants;
import com.system.dao.DatabaseTableMapper;
import com.system.dao.KingDeeCommonConfigMapper;
import com.system.serivce.IKingDeeCommonConfigService;
import com.system.transfer.configure.TableStructureCreateInVo;
import com.system.transfer.kingdee.*;
import com.system.transfer.response.RestResponse;
import com.system.utils.StringUtil;
import com.system.utils.TableStructureUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Inori
 */
@Service
public class KingDeeCommonConfigServiceImpl implements IKingDeeCommonConfigService {

    @Autowired
    private KingDeeCommonConfigMapper kingDeeCommonConfigMapper;

    @Autowired
    private KingDeeCommonPushConstants kingDeeCommonPushConstants;

    @Autowired
    private KingDeeCommonSynConstants kingDeeCommonSynConstants;

    @Autowired
    private DatabaseTableMapper databaseTableMapper;


    @Override
    public KingdeeCommonConfigListOutVo kingDeeCommonConfigList(KingDeeCommonConfigListInVo inVo) {
        Page<KingdeeCommonConfigListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<KingdeeCommonConfigListOutVoRecords> recordsList = kingDeeCommonConfigMapper.kingDeeCommonConfigList(page, inVo);

        KingdeeCommonConfigListOutVo outVo = new KingdeeCommonConfigListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public RestResponse kingDeeCommonConfigCreate(KingdeeCommonConfigCreateInVo inVo) {
        KingDeeCommonConfigOneInVo oneInVo = new KingDeeCommonConfigOneInVo(inVo.getSFormId(), inVo.getDocType(), inVo.getFlag());
        KingdeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.kingDeeCommonConfigOne(oneInVo);
        if (StringUtil.isNotNull(records)) {
            return RestResponse.fail("配置方向为: " + (inVo.getFlag() == 1 ? "MES->ERP" : "ERP->MES") + " 标识为: " + (inVo.getFlag() == 1 ? inVo.getDocType() : inVo.getSFormId()) + " 的配置已存在");
        }

        kingDeeCommonConfigMapper.kingDeeCommonConfigCreate(inVo);
        if (inVo.getFlag() == 1) {
            kingDeeCommonPushConstants.set(inVo.getDocType());
        } else {
            kingDeeCommonSynConstants.set(inVo.getSFormId());

            String formJson = TableStructureUtil.getFormGenerator(inVo.getSFormId(), inVo.getName(), inVo.getKingdeeFiledDetail());
            databaseTableMapper.tableStructureCreate(new TableStructureCreateInVo(inVo.getSFormId(), inVo.getSFormId().toLowerCase(), inVo.getName(), formJson));

            databaseTableMapper.databaseTableCreateByKingDee(new TableStructureCreateInVo(inVo.getSFormId().toLowerCase(), "'" + inVo.getName() + "'"), TableStructureUtil.getFieldListBySyn(inVo.getKingdeeFiledDetail()));
        }
        return RestResponse.success();
    }

    @Override
    public RestResponse kingDeeCommonConfigUpdate(KingdeeCommonConfigUpdateInVo inVo) {
        kingDeeCommonConfigMapper.kingDeeCommonConfigUpdate(inVo);
        if (inVo.getFlag() == 1) {
            kingDeeCommonPushConstants.set(inVo.getDocType());
        } else {
            kingDeeCommonSynConstants.set(inVo.getSFormId());
        }
        return RestResponse.success();
    }

    @Override
    public RestResponse kingDeeCommonConfigDelete(KingdeeCommonConfigDeleteInVo inVo) {
        KingdeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.getKingDeeCommonConfigById(inVo.getId());

        kingDeeCommonConfigMapper.kingDeeCommonConfigDelete(inVo);

        if (records.getFlag() == 1) {
            kingDeeCommonPushConstants.del(records.getDocType());
        } else {
            kingDeeCommonSynConstants.del(records.getSFormId());
        }
        return RestResponse.success();
    }


}
