package com.system.constants;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.dao.DatabaseTableMapper;
import com.system.transfer.configure.TableStructureListInVo;
import com.system.transfer.configure.TableStructureListOutVoRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Inori
 */
@Component
public class FormTableStructureConstants {

    private Map<String, Map<String, String>> map = new ConcurrentHashMap<>();

    @Autowired
    private DatabaseTableMapper databaseTableMapper;


    @PostConstruct
    public void init() {
        List<TableStructureListOutVoRecords> recordsList = databaseTableMapper.tableStructureList(new Page<>(1, 10000), new TableStructureListInVo());
        for (TableStructureListOutVoRecords records : recordsList) {
            this.map.put(records.getFormId(), this.purchaseKingDeeSyn(records));
        }
    }

    public Map<String, String> get(String formId) {
        return this.map.get(formId);
    }

    private Map<String, String> purchaseKingDeeSyn(TableStructureListOutVoRecords records) {
        Map<String, String> temp = new HashMap<>(6);
        temp.put("formId", records.getFormId());
        temp.put("dbTableName", records.getDbTableName());
        temp.put("formJson", records.getFormJson());
        return temp;
    }


}
