package com.system.constants;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.dao.KingDeeCommonConfigMapper;
import com.system.transfer.kingdee.KingDeeCommonConfigListInVo;
import com.system.transfer.kingdee.KingDeeCommonConfigOneInVo;
import com.system.transfer.kingdee.KingdeeCommonConfigListOutVoRecords;
import com.system.utils.JsonUtil;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Inori
 */
@Component
public class KingDeeCommonSynConstants {

    private Map<String, Map<String, String>> map = new ConcurrentHashMap<>();

    @Autowired
    private KingDeeCommonConfigMapper kingDeeCommonConfigMapper;


    @PostConstruct
    public void init() {
        List<KingdeeCommonConfigListOutVoRecords> recordsList = kingDeeCommonConfigMapper.kingDeeCommonConfigList(new Page<>(1, 10000), new KingDeeCommonConfigListInVo(-1));
        for (KingdeeCommonConfigListOutVoRecords records : recordsList) {
            this.map.put(records.getSFormId(), this.purchaseKingDeeSyn(records));
        }
    }

    public Map<String, String> get(String sFormId) {
        return this.map.get(sFormId);
    }

    public Map<String, String> getKingDee(String docType) {
        KingdeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.kingDeeCommonConfigOne(new KingDeeCommonConfigOneInVo("", docType, -1));
        if (StringUtil.isNull(records)) {
            return new HashMap<>(0);
        }
        return this.map.get(records.getSFormId());
    }

    public void set(String sFormId) {
        KingdeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.kingDeeCommonConfigOne(new KingDeeCommonConfigOneInVo(sFormId, "", -1));

        if (records != null) {
            this.map.remove(sFormId);

            this.map.put(records.getSFormId(), this.purchaseKingDeeSyn(records));
        }
    }

    private Map<String, String> purchaseKingDeeSyn(KingdeeCommonConfigListOutVoRecords records) {
        Map<String, String> temp = new HashMap<>(6);
        temp.put("sFormId", records.getSFormId());
        temp.put("docType", records.getDocType());
        temp.put("name", records.getName());
        temp.put("primaryKeyField", records.getPrimaryKeyField());
        temp.put("entryPrimaryKeyField", records.getEntryPrimaryKeyField());
        temp.put("mesEntryName", records.getMesEntryName());
        temp.put("kingdeeFiledDetail", records.getKingdeeFiledDetail());
        temp.put("plugInUrl", records.getPlugInUrl());
        temp.put("customSql", records.getCustomSql());
        return temp;
    }

    public void del(String formId) {
        this.map.remove(formId);
    }

    /**
     * 封装金蝶字段
     */
    public static Map<String, String> purchaseKingDee(List<Map<String, String>> fieldList) {
        Map<String, String> key = new LinkedHashMap<>();
        for (Map<String, String> map : fieldList) {
            String kingDeeField = map.get("kingdeeField");
            String indexField = map.get("indexField");
            if (StringUtil.isNotBlank(indexField)) {
                kingDeeField = kingDeeField + "." + indexField;
            }
            key.put(kingDeeField, kingDeeField);
        }
        return key;
    }

    /**
     * 封装第三方字段
     */
    public static void purchaseIms(List<List<Object>> list, List<Map<String, String>> fieldList, Map<String, Object> map, List<Map<String, Object>> imsList) {
        for (List<Object> objectList : list) {
            Map<String, Object> temp = new HashMap<>(fieldList.size());
            for (int i = 0; i < fieldList.size(); i++) {
                //是否是明细字段
                if ("true".equals(fieldList.get(i).get("isDetailField"))) {
                    temp.put(fieldList.get(i).get("thirdPartyField"), objectList.get(i));
                } else {
                    map.put(fieldList.get(i).get("thirdPartyField"), objectList.get(i));
                }
            }
            if (!CollectionUtils.isEmpty(temp)) {
                imsList.add(temp);
            }
        }
    }

    /**
     * 封装第三方字段
     */
    public static void purchaseSqlIms(List<Object> list, List<Map<String, String>> fieldList, Map<String, Object> map) {
        List<Map<String, Object>> imsList = new ArrayList<>();
        for (Object object : list) {
            Map<String, Object> temp = JsonUtil.toMap(JsonUtil.toString(object), String.class, Object.class);

            Map<String, Object> request = new LinkedHashMap<>();
            for (Map<String, String> temp02Map : fieldList) {
                if ("true".equals(temp02Map.get("isDetailField"))) {
                    request.put(temp02Map.get("thirdPartyField"), temp.get(temp02Map.get("kingdeeField")));
                } else {
                    map.put(temp02Map.get("thirdPartyField"), temp.get(temp02Map.get("kingdeeField")));
                }
            }
            if (!CollectionUtils.isEmpty(request)) {
                imsList.add(request);
            }
        }
        map.put("children", imsList);
    }


}
