package com.system.controller;

import com.system.serivce.ISynchronizationRecordsService;
import com.system.transfer.kingdee.SynchronizationRecordsDeleteInVo;
import com.system.transfer.kingdee.SynchronizationRecordsListInVo;
import com.system.transfer.kingdee.SynchronizationRecordsListOutVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "同步记录")
@RestController
@RequestMapping("/api")
public class SynchronizationRecordsController {

    @Autowired
    private ISynchronizationRecordsService synchronizationRecordsService;


    @ApiOperation("同步记录列表")
    @GetMapping("/synchronization/records/list")
    public RestResponse synchronizationRecordsList(@ModelAttribute SynchronizationRecordsListInVo inVo) {
        SynchronizationRecordsListOutVo outVo = synchronizationRecordsService.synchronizationRecordsList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("同步记录删除")
    @DeleteMapping("/synchronization/records/delete")
    public RestResponse synchronizationRecordsDelete(@ModelAttribute SynchronizationRecordsDeleteInVo inVo) {
        synchronizationRecordsService.synchronizationRecordsDelete(inVo);
        return RestResponse.success();
    }


}
