package com.system.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.transfer.kingdee.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface KingDeeCommonConfigMapper {

    /**
     * 金蝶通用配置列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<KingdeeCommonConfigListOutVoRecords> kingDeeCommonConfigList(@Param("page") Page<KingdeeCommonConfigListOutVoRecords> page, @Param("inVo") KingDeeCommonConfigListInVo inVo);

    /**
     * 金蝶通用配置
     *
     * @param inVo 条件
     * @return 金蝶通用配置
     */
    KingdeeCommonConfigListOutVoRecords kingDeeCommonConfigOne(KingDeeCommonConfigOneInVo inVo);

    /**
     * 金蝶通用配置创建
     *
     * @param inVo 条件
     */
    void kingDeeCommonConfigCreate(KingdeeCommonConfigCreateInVo inVo);

    /**
     * 金蝶通用配置更新
     *
     * @param inVo 条件
     */
    void kingDeeCommonConfigUpdate(KingdeeCommonConfigUpdateInVo inVo);

    /**
     * 根据ID查询金蝶通用配置
     *
     * @param id ID
     * @return 金蝶通用配置
     */
    KingdeeCommonConfigListOutVoRecords getKingDeeCommonConfigById(Integer id);

    /**
     * 金蝶通用配置删除
     *
     * @param inVo 条件
     */
    void kingDeeCommonConfigDelete(KingdeeCommonConfigDeleteInVo inVo);


}
