package com.system.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.transfer.kingdee.SynchronizationRecordsDeleteInVo;
import com.system.transfer.kingdee.SynchronizationRecordsListInVo;
import com.system.transfer.kingdee.SynchronizationRecordsListOutVoRecords;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
public interface SynchronizationRecordsMapper {


    /**
     * 金蝶同步记录列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<SynchronizationRecordsListOutVoRecords> synchronizationRecordsList(@Param("page") Page<SynchronizationRecordsListOutVoRecords> page, @Param("inVo") SynchronizationRecordsListInVo inVo);

    /**
     * 根据状态查询金蝶同步记录
     *
     * @param statusList 状态列表
     * @return 同步记录
     */
    List<SynchronizationRecordsListOutVoRecords> getSynchronizationRecordsListByStatus(@Param("statusList") List<Integer> statusList);

    /**
     * 金蝶同步临时记录创建
     *
     * @param tempList 数据
     */
    void synchronizationRecordsTempCreate(@Param("tempList") List<Map<String, Object>> tempList);

    /**
     * 金蝶同步临时记录列表
     *
     * @return 列表
     */
    List<Map<String, Object>> synchronizationRecordsTempList();

    /**
     * 金蝶同步记录创建
     *
     * @param tempList 数据
     */
    void synchronizationRecordsCreate(@Param("tempList") List<Map<String, Object>> tempList);

    /**
     * 根据ID删除数据
     *
     * @param idList ID列表
     */
    void synchronizationRecordsTempDelete(@Param("idList") List<Integer> idList);

    /**
     * 根据ID更新金蝶同步记录状态
     *
     * @param idList ID列表
     */
    void synchronizationRecordsUpdateByIdList(@Param("idList") List<Integer> idList);

    /**
     * 金蝶同步记录更新
     *
     * @param id      ID
     * @param queueId 唯一标识
     * @param message 错误信息
     * @param status  状态
     */
    void synchronizationRecordsUpdate(@Param("id") Integer id, @Param("queueId") String queueId, @Param("message") String message, @Param("status") Integer status);

    /**
     * 金蝶同步记录删除
     *
     * @param inVo 条件
     */
    void synchronizationRecordsDelete(SynchronizationRecordsDeleteInVo inVo);


}
