package com.system.oauth.system.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.system.oauth.system.entity.SysUserDepart;
import com.system.oauth.system.entity.UserMessage;
import com.system.oauth.system.model.DepartIdModel;

import java.util.List;

/**
 * <p>
 * SysUserDpeart用户组织机构service
 * </p>
 *
 *
 */
public interface ISysUserDepartService extends IService<SysUserDepart> {
	

	/**
	 * 根据指定用户id查询部门信息
	 * @param userId
	 * @return
	 */
	List<DepartIdModel> queryDepartIdsOfUser(String userId);
	

	/**
	 * 根据部门id查询用户信息
	 * @param depId
	 * @return
	 */
	List<UserMessage> queryUserByDepId(String depId);
  	/**
	 * 根据部门code，查询当前部门和下级部门的用户信息
	 */
	public List<UserMessage> queryUserByDepCode(String depCode, String realname);
}
