package com.system.quartz.job;

import com.system.scheduler.LicScheduler;
import com.system.serivce.ISynchronizationService;
import org.apache.commons.lang.time.DateFormatUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author Inori
 */
@Component
public class SynchronizationJob implements Job {

    @Autowired
    private ISynchronizationService synchronizationService;

    @Autowired
    private LicScheduler licScheduler;


    @Override
    public void execute(JobExecutionContext jobExecutionContext) {
        if (!licScheduler.isFlag()) {
            return;
        }
        System.out.println("开启自动同步定时任务，开始时间: " + DateFormatUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        synchronizationService.synchronization();
    }


}
