package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.dao.SynchronizationRecordsMapper;
import com.system.serivce.ISynchronizationRecordsService;
import com.system.transfer.kingdee.SynchronizationRecordsDeleteInVo;
import com.system.transfer.kingdee.SynchronizationRecordsListInVo;
import com.system.transfer.kingdee.SynchronizationRecordsListOutVo;
import com.system.transfer.kingdee.SynchronizationRecordsListOutVoRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Inori
 */
@Service
public class SynchronizationRecordsServiceImpl implements ISynchronizationRecordsService {

    @Autowired
    private SynchronizationRecordsMapper synchronizationRecordsMapper;


    @Override
    public SynchronizationRecordsListOutVo synchronizationRecordsList(SynchronizationRecordsListInVo inVo) {
        Page<SynchronizationRecordsListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<SynchronizationRecordsListOutVoRecords> recordsList = synchronizationRecordsMapper.synchronizationRecordsList(page, inVo);

        SynchronizationRecordsListOutVo outVo = new SynchronizationRecordsListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public void synchronizationRecordsDelete(SynchronizationRecordsDeleteInVo inVo) {
        synchronizationRecordsMapper.synchronizationRecordsDelete(inVo);
    }


}
