package com.system.controller;

import com.system.serivce.ISynchronizationService;
import com.system.transfer.configure.InitConnectParamCheckInVo;
import com.system.transfer.configure.InitConnectParamCreateInVo;
import com.system.transfer.configure.InitConnectParamOutVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "自动同步")
@RestController
@RequestMapping("/api")
public class SynchronizationController {

    @Autowired
    private ISynchronizationService synchronizationService;


    @ApiOperation("开启自动同步")
    @GetMapping("/start/synchronization")
    public RestResponse startSynchronization() {
        return synchronizationService.startSynchronization();
    }

    @ApiOperation("关闭自动同步")
    @GetMapping("/turn/off/synchronization")
    public RestResponse turnOffSynchronization() {
        return synchronizationService.turnOffSynchronization();
    }

    @ApiOperation("自动同步定时任务")
    @GetMapping("/synchronization/records")
    public RestResponse synchronizationRecords() {
        return RestResponse.success(synchronizationService.synchronizationStatus());
    }

    @ApiOperation("手动同步")
    @GetMapping("/manual/synchronization")
    public RestResponse manualSynchronization() {
        return synchronizationService.manualSynchronization();
    }

    @ApiOperation("查询金蝶参数")
    @GetMapping("/init/connect/param")
    public RestResponse initConnectParam() {
        InitConnectParamOutVo outVo = synchronizationService.initConnectParam();
        return RestResponse.success(outVo);
    }

    @ApiOperation("保存金蝶参数")
    @PostMapping("/init/connect/param/create")
    public RestResponse initConnectParamCreate(@RequestBody @Validated InitConnectParamCreateInVo inVo) {
        return synchronizationService.initConnectParamCreate(inVo);
    }

    @ApiOperation("校验金蝶参数")
    @PostMapping("/init/connect/param/check")
    public RestResponse initConnectParamCheck(@RequestBody @Validated InitConnectParamCheckInVo inVo) {
        return synchronizationService.initConnectParamCheck(inVo);
    }


}
