package com.system.constants;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.dao.KingDeeCommonConfigMapper;
import com.system.transfer.kingdee.KingDeeCommonConfigListInVo;
import com.system.transfer.kingdee.KingDeeCommonConfigOneInVo;
import com.system.transfer.kingdee.KingdeeCommonConfigListOutVoRecords;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Inori
 */
@Component
public class KingDeeCommonPushConstants {

    private Map<String, Map<String, String>> map = new ConcurrentHashMap<>();

    @Autowired
    private KingDeeCommonConfigMapper kingDeeCommonConfigMapper;


    @PostConstruct
    public void init() {
        List<KingdeeCommonConfigListOutVoRecords> recordsList = kingDeeCommonConfigMapper.kingDeeCommonConfigList(new Page<>(1, 10000), new KingDeeCommonConfigListInVo(1));
        for (KingdeeCommonConfigListOutVoRecords records : recordsList) {
            this.map.put(records.getDocType(), this.getKingDeeCommonConfigDetail(records));
        }
    }

    public Map<String, String> get(String formId) {
        if (CollectionUtils.isEmpty(this.map)) {
            return new HashMap<>(1);
        }
        return this.map.get(formId);
    }

    public void set(String docType) {
        KingdeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.kingDeeCommonConfigOne(new KingDeeCommonConfigOneInVo("", docType, 1));

        if (StringUtil.isNotNull(records)) {
            this.map.remove(docType);

            this.map.put(records.getDocType(), this.getKingDeeCommonConfigDetail(records));
        }
    }

    private Map<String, String> getKingDeeCommonConfigDetail(KingdeeCommonConfigListOutVoRecords records) {
        Map<String, String> result = new HashMap<>(10);
        result.put("docType", records.getDocType());
        result.put("sFormId", records.getSFormId());
        result.put("kingDeeLogName", records.getName());
        result.put("entryName", records.getEntryName());
        result.put("fathersFormId", records.getFathersFormId());
        result.put("fatherEntryName", records.getFatherEntryName());
        result.put("pushRule", records.getPushRule());
        result.put("isInTransaction", String.valueOf(records.getIsInTransaction()));
        result.put("isAutoPerform", String.valueOf(records.getIsAutoPerform()));
        result.put("kingDeeFiledDetail", records.getKingdeeFiledDetail());
        result.put("plugInUrl", records.getPlugInUrl());
        result.put("customSql", records.getCustomSql());
        return result;
    }

    public void del(String docType) {
        this.map.remove(docType);
    }


}
