package com.system.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.transfer.kingdee.ThirdPartyLogCreateInVo;
import com.system.transfer.kingdee.ThirdPartyLogListInVo;
import com.system.transfer.kingdee.ThirdPartyLogListOutVoRecords;
import com.system.transfer.kingdee.ThirdPartyLogUpdateInVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface ThirdPartyLogMapper {

    /**
     * 第三方日志列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<ThirdPartyLogListOutVoRecords> thirdPartyLogList(@Param("page") Page<ThirdPartyLogListOutVoRecords> page, @Param("inVo") ThirdPartyLogListInVo inVo);

    /**
     * 唯一标识是否存在
     *
     * @param queueId 唯一标识
     * @return 是否存在
     */
    Integer getThirdPartyLogByQueueId(String queueId);

    /**
     * 第三方日志创建
     *
     * @param inVo 条件
     */
    void thirdPartyLogCreate(ThirdPartyLogCreateInVo inVo);

    /**
     * 第三方日志更新
     *
     * @param inVo 条件
     */
    void thirdPartyLogUpdate(ThirdPartyLogUpdateInVo inVo);


}
