package com.system.utils;

import com.system.constants.KingDeeConstants;
import com.system.dao.SynchronizationRecordsMapper;
import com.system.dao.ThirdPartyLogMapper;
import com.system.transfer.kingdee.SynchronizationRecordsDeleteInVo;
import com.system.transfer.kingdee.ThirdPartyLogCreateInVo;
import com.system.transfer.kingdee.ThirdPartyLogUpdateInVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Component
public class ThirdPartyLogUtil {

    @Autowired
    private ThirdPartyLogMapper thirdPartyLogMapper;

    @Autowired
    private SynchronizationRecordsMapper synchronizationRecordsMapper;


    public Integer isExist(String queueId) {
        return thirdPartyLogMapper.getThirdPartyLogByQueueId(queueId);
    }

    public Integer thirdPartyLogCreate(String imsLogName, String docType, String queueId, String request, String response, Integer flag) {
        ThirdPartyLogCreateInVo inVo = new ThirdPartyLogCreateInVo();
        inVo.setName(imsLogName);
        inVo.setCode(docType);
        inVo.setQueueId(queueId);
        inVo.setRequest(request);
        inVo.setResponse(response);
        inVo.setFlag(flag);

        thirdPartyLogMapper.thirdPartyLogCreate(inVo);
        return inVo.getId();
    }

    public void sendThirdPartyLogCreate(String imsLogName, String docType, String queueId, String request, String response, Integer id) {
        ThirdPartyLogCreateInVo inVo = new ThirdPartyLogCreateInVo();
        inVo.setName(imsLogName);
        inVo.setCode(docType);

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map)) {
            if (map.containsKey(KingDeeConstants.CODE_NAME) && KingDeeConstants.SUCCESS_CODE.equals(map.get(KingDeeConstants.CODE_NAME))) {
                inVo.setFlag(1);
                synchronizationRecordsMapper.synchronizationRecordsDelete(new SynchronizationRecordsDeleteInVo(id));
            } else {
                inVo.setFlag(0);
                if (map.containsKey(KingDeeConstants.MSG_NAME)) {
                    inVo.setMessage(map.get("resultMsg").toString());
                }
                synchronizationRecordsMapper.synchronizationRecordsUpdate(id, queueId, inVo.getMessage(), 2);
            }
        } else {
            inVo.setFlag(0);
            inVo.setMessage("第三方响应信息错误");
            synchronizationRecordsMapper.synchronizationRecordsUpdate(id, queueId, inVo.getMessage(), 2);
        }

        inVo.setQueueId(queueId);
        inVo.setRequest(request);
        inVo.setResponse(response);

        thirdPartyLogMapper.thirdPartyLogCreate(inVo);
    }

    public void thirdPartyLogUpdate(Integer id, String response) {
        ThirdPartyLogUpdateInVo inVo = new ThirdPartyLogUpdateInVo();
        inVo.setId(id);
        inVo.setResponse(response);

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (KingDeeConstants.SUCCESS_CODE.equals(map.get(KingDeeConstants.CODE_NAME))) {
            inVo.setFlag(1);
        } else {
            inVo.setFlag(0);
            String message = String.valueOf(map.get("resultMsg"));
            List<Object> tempList = JsonUtil.toList(JsonUtil.toString(map.get("resultData")), Object.class);
            if (!CollectionUtils.isEmpty(tempList)) {
                message = message + " " + tempList.stream()
                        .map(m -> (String) JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class).get("Msg"))
                        .collect(Collectors.joining(", "));
            }
            inVo.setMessage(message);
        }
        thirdPartyLogMapper.thirdPartyLogUpdate(inVo);
    }

    public void toThirdPartyLogUpdate(Integer id, String response, String message) {
        ThirdPartyLogUpdateInVo inVo = new ThirdPartyLogUpdateInVo();
        inVo.setId(id);
        inVo.setResponse(response);
        inVo.setMessage(message);
        if (StringUtil.isNotBlank(message)) {
            inVo.setFlag(0);
        } else {
            inVo.setFlag(1);
        }

        thirdPartyLogMapper.thirdPartyLogUpdate(inVo);
    }


}
