package com.system.utils;

import com.system.config.ThreadLocalConfig;
import com.system.constants.KingDeeConstants;
import com.system.dao.KingDeeLogMapper;
import com.system.transfer.kingdee.KingDeeLogCreateInVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Component
public class KingDeeLogUtil {

    @Autowired
    private KingDeeLogMapper kingDeeLogMapper;


    public void kingDeeSynLogCreate(String queueId, String kingDeeLogName, String request, List<List<Object>> response) {
        KingDeeLogCreateInVo inVo = this.purchaseInVo(kingDeeLogName, queueId, request, JsonUtil.toString(response));

        String errorName = "Errors";
        if (CollectionUtils.isEmpty(response)) {
            inVo.setFlag(0);
        } else if (response.get(0).get(0).toString().contains(errorName)) {
            inVo.setFlag(0);
            inVo.setMessage(KingDeeUtil.getMessage(response.get(0).get(0)));
        } else {
            inVo.setFlag(1);
        }

        kingDeeLogMapper.kingDeeLogCreate(inVo);
    }

    public void kingDeePushLogCreate(String kingDeeLogName, String queueId, String request, String response) {
        KingDeeLogCreateInVo inVo = this.purchaseInVo(kingDeeLogName, queueId, request, response);

        if (StringUtil.isNotBlank(response) && KingDeeUtil.isError(response)) {
            inVo.setFlag(0);
            inVo.setMessage(KingDeeUtil.getMessage(response));
        } else {
            inVo.setFlag(1);
        }

        kingDeeLogMapper.kingDeeLogCreate(inVo);
    }

    public void kingDeeLogCreate(String kingDeeLogName, String queueId, String request, String response) {
        KingDeeLogCreateInVo inVo = this.purchaseInVo(kingDeeLogName, queueId, request, response);

        purchaseOn(response, inVo);
    }

    public void kingDeeSqlLogCreate(String kingDeeLogName, String queueId, String request, String response) {
        KingDeeLogCreateInVo inVo = this.purchaseInVo(kingDeeLogName, queueId, request, response);
        try {
            inVo.setRequest(DesHelperUtil.decrypt(request, StandardCharsets.UTF_8, "MES&&DES"));
        } catch (Exception e) {
            e.printStackTrace();
        }

        purchaseOn(response, inVo);
    }

    public void kingDeeErrorLogCreate(String kingDeeLogName, String queueId, String request, String response) {
        KingDeeLogCreateInVo inVo = this.purchaseInVo(kingDeeLogName, queueId, request, response);

        inVo.setMessage(response);
        inVo.setResponse("");
        purchaseOn(response, inVo);
    }

    private KingDeeLogCreateInVo purchaseInVo(String kingDeeLogName, String queueId, String request, String response) {
        KingDeeLogCreateInVo inVo = new KingDeeLogCreateInVo();
        inVo.setName(kingDeeLogName);
        inVo.setQueueId(queueId);
        inVo.setRequest(request);
        inVo.setResponse(response);

        Map<String, Object> temp = ThreadLocalConfig.get();
        int costTime = StringUtil.isNotNull(temp.get("costTime")) ? Integer.parseInt(temp.get("costTime").toString()) : 0;
        inVo.setCostTime(costTime);

        return inVo;
    }

    private void purchaseOn(String response, KingDeeLogCreateInVo inVo) {
        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (StringUtil.isNotBlank(response) && !CollectionUtils.isEmpty(map)) {
            if (map.containsKey(KingDeeConstants.CODE_NAME) && KingDeeConstants.SUCCESS_CODE.equals(map.get(KingDeeConstants.CODE_NAME))) {
                inVo.setFlag(1);
            } else {
                inVo.setFlag(0);
                inVo.setMessage(String.valueOf(map.get("resultMsg")));
            }
        } else {
            inVo.setFlag(0);
        }

        kingDeeLogMapper.kingDeeLogCreate(inVo);
    }


}
