package com.shr.controller;

import com.shr.annotion.AccessLog;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IUserService;
import com.shr.transfer.user.UserListInVo;
import com.shr.transfer.user.UserListOutVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class UserController {

    @Autowired
    private IUserService userService;


    @AccessLog("用户列表")
    @PostMapping("/user/list")
    public RestResponse userList(@RequestBody(required = true) @Validated UserListInVo inVo) {
        UserListOutVo outVo = userService.userList(inVo);
        return RestResponse.success(outVo);
    }


}
