/*
 * Decompiled with CFR 0.152.
 */
package com.eetrust.security.plugin;

import com.eetrust.security.crypto.EncoderException;
import com.eetrust.security.plugin.MessageRequest;
import com.eetrust.security.plugin.RequestException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import sun.misc.BASE64Decoder;

public class SIDPlugin {
    private static final String AUTH_TYPE_CERTIFICATE = "CertAuth";
    private static final String AUTH_TYPE_CERTIFICATE_V5 = "EKeyAuthV5";
    private static final String AUTH_TYPE_USERPASSWORD = "UserPasswordAuth";
    private static final String AUTH_TYPE_TEMPPASSWORD = "TempPasswordAuth";
    private static final String AUTH_TYPE_LDAPPASSWORD = "LDAPPasswordAuth";
    private static final String AUTH_TYPE_CERTIFICATE_V3 = "EKeyAuthV3";
    private static final String AUTH_TYPE_SMS_CODE = "SMSCodeAuth";
    private static final String SECURITY_TYPE_UPDATE_PIN = "updatePIN";
    private static final String SECURITY_TYPE_SEND_SMS_CODE = "sendSMSCode";
    private static final String SECURITY_TYPE_GET_SSO_TOKEN = "getSSOToken";
    private static final String VERIFY_TYPE_TICKET = "ticket";
    private static final String VERIFY_TYPE_SIGNATURE = "signature";
    private static final String VERIFY_TYPE_CLIENT_TICKET = "clientTicket";
    private static final String VERIFY_TYPE_WEB_TOKEN = "webToken";
    private String serverIp;
    private int serverPort = 80;
    private String serverName;
    private String communicationProtocol = "http";
    private String charset = "GBK";
    private boolean queryAuthorizedApps = false;
    private String proxyAppCode = null;
    private String clientIP = null;
    private String passport;
    private String ssoToken;
    private Map<String, String> userData = new HashMap<String, String>();
    private List<String> accounts = new ArrayList<String>();
    private List<String> userAuthorizedApps = new ArrayList<String>();
    private String sequenceID;
    private String errorCode;
    private String errorMsg;

    public SIDPlugin(String serverIp, int serverPort) {
        this.serverIp = serverIp;
        this.serverPort = serverPort;
    }

    public int Auth_VerifyCert(String licenseKey, String cert, String random, String cipher) {
        return this.Auth_VerifyCert(licenseKey, cert, random, cipher, null, null);
    }

    public int Auth_VerifyCert(String licenseKey, String cert, String random, String cipher, HttpServletResponse response, Map<String, String> cookieConfig) {
        Element root;
        block20: {
            String userAuthorizedApps;
            Element accountsElement;
            Element userDataElement;
            block21: {
                String respResult;
                block19: {
                    String respMessage;
                    block18: {
                        if (this.isEmpty(this.serverIp)) {
                            this.setErrorCode("ERROR_CODE_EMPTY_IP");
                            this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528!");
                            return 1;
                        }
                        if (this.isEmpty(licenseKey) || this.isEmpty(cert) || this.isEmpty(random) || this.isEmpty(cipher)) {
                            this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                            this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                            return 1;
                        }
                        StringBuffer reqMessage = new StringBuffer();
                        reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                        reqMessage.append("<sid-auth>");
                        reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                        reqMessage.append("<auth-type>EKeyAuthV5</auth-type>");
                        reqMessage.append("<auth-queryAuthorizedApps>" + (this.queryAuthorizedApps ? "0" : "1") + "</auth-queryAuthorizedApps>");
                        reqMessage.append("<auth-token>");
                        reqMessage.append("<token-cert>" + cert + "</token-cert>");
                        reqMessage.append("<token-random>" + random + "</token-random>");
                        reqMessage.append("<token-cipher>" + cipher + "</token-cipher>");
                        reqMessage.append("<token-clientIp>" + (this.isEmpty(this.clientIP) ? "" : this.clientIP) + "</token-clientIp>");
                        reqMessage.append("</auth-token>");
                        reqMessage.append("</sid-auth>");
                        MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                        respMessage = messageRequest.sendMessage(reqMessage.toString());
                        if (!this.isEmpty(respMessage)) break block18;
                        this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                        return 1;
                    }
                    Document document = DocumentHelper.parseText((String)respMessage);
                    root = document.getRootElement();
                    respResult = root.elementTextTrim("result");
                    if (respResult != null) break block19;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                    return 1;
                }
                if (Integer.parseInt(respResult) != 0) break block20;
                if (response == null || cookieConfig == null || cookieConfig.isEmpty() || !this.isEmpty(cookieConfig.get("cookieMaxAge")) && !this.isEmpty(cookieConfig.get("cookiePath")) && !this.isEmpty(cookieConfig.get("cookieName")) && !this.isEmpty(cookieConfig.get("cookieSecure")) && !this.isEmpty(cookieConfig.get("cookieDomain"))) break block21;
                this.setErrorCode("ERROR_CODE_COOKIE_CONFIG");
                this.setErrorMsg("Cookie\u8bbe\u7f6e\u53c2\u6570\u9519\u8bef!");
                return 1;
            }
            this.passport = root.elementTextTrim("passport");
            this.ssoToken = root.elementTextTrim("ssoToken");
            if (response != null && cookieConfig != null && !cookieConfig.isEmpty()) {
                Cookie cookie = new Cookie(cookieConfig.get("cookieName"), this.ssoToken);
                cookie.setMaxAge(Integer.parseInt(cookieConfig.get("cookieMaxAge")));
                cookie.setPath(cookieConfig.get("cookiePath"));
                cookie.setDomain(cookieConfig.get("cookieDomain"));
                cookie.setSecure(Boolean.parseBoolean(cookieConfig.get("cookieSecure")));
                response.addCookie(cookie);
            }
            if ((userDataElement = root.element("userData")) != null) {
                Iterator it = userDataElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.userData.put(e.getName(), e.getText());
                }
            }
            if ((accountsElement = root.element("accounts")) != null) {
                Iterator it = accountsElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.accounts.add(e.getText());
                }
            }
            String string = userAuthorizedApps = root.elementTextTrim("userAuthorizedApps") == null ? "" : root.elementTextTrim("userAuthorizedApps");
            if (this.queryAuthorizedApps && !this.isEmpty(userAuthorizedApps)) {
                StringTokenizer commaToker = new StringTokenizer(userAuthorizedApps, "|");
                String[] params = new String[commaToker.countTokens()];
                int i = 0;
                while (i < params.length) {
                    params[i] = commaToker.nextToken();
                    if (!this.isEmpty(params[i])) {
                        // empty if block
                    }
                    this.userAuthorizedApps.add(params[i]);
                    ++i;
                }
            }
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Auth_VerifyCertExt(String licenseKey, String signatureData) {
        return this.Auth_VerifyCertExt(licenseKey, signatureData, null, null);
    }

    public int Auth_VerifyCertExt(String licenseKey, String signatureData, HttpServletResponse response, Map<String, String> cookieConfig) {
        Element root;
        block20: {
            String userAuthorizedApps;
            Element accountsElement;
            Element userDataElement;
            block21: {
                String respResult;
                block19: {
                    String respMessage;
                    block18: {
                        if (this.isEmpty(this.serverIp)) {
                            this.setErrorCode("ERROR_CODE_EMPTY_IP");
                            this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528!");
                            return 1;
                        }
                        if (this.isEmpty(licenseKey) || this.isEmpty(signatureData)) {
                            this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                            this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                            return 1;
                        }
                        StringBuffer reqMessage = new StringBuffer();
                        reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                        reqMessage.append("<sid-auth>");
                        reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                        reqMessage.append("<auth-type>CertAuth</auth-type>");
                        reqMessage.append("<auth-queryAuthorizedApps>" + (this.queryAuthorizedApps ? "0" : "1") + "</auth-queryAuthorizedApps>");
                        reqMessage.append("<auth-token>");
                        reqMessage.append("<token-signatureData>" + signatureData + "</token-signatureData>");
                        reqMessage.append("<token-clientIp>" + (this.isEmpty(this.clientIP) ? "" : this.clientIP) + "</token-clientIp>");
                        reqMessage.append("</auth-token>");
                        reqMessage.append("</sid-auth>");
                        MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                        respMessage = messageRequest.sendMessage(reqMessage.toString());
                        if (!this.isEmpty(respMessage)) break block18;
                        this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                        return 1;
                    }
                    Document document = DocumentHelper.parseText((String)respMessage);
                    root = document.getRootElement();
                    respResult = root.elementTextTrim("result");
                    if (respResult != null) break block19;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                    return 1;
                }
                if (Integer.parseInt(respResult) != 0) break block20;
                if (response == null || cookieConfig == null || cookieConfig.isEmpty() || !this.isEmpty(cookieConfig.get("cookieMaxAge")) && !this.isEmpty(cookieConfig.get("cookiePath")) && !this.isEmpty(cookieConfig.get("cookieName")) && !this.isEmpty(cookieConfig.get("cookieSecure")) && !this.isEmpty(cookieConfig.get("cookieDomain"))) break block21;
                this.setErrorCode("ERROR_CODE_COOKIE_CONFIG");
                this.setErrorMsg("Cookie\u8bbe\u7f6e\u53c2\u6570\u9519\u8bef!");
                return 1;
            }
            this.passport = root.elementTextTrim("passport");
            this.ssoToken = root.elementTextTrim("ssoToken");
            if (response != null && cookieConfig != null && !cookieConfig.isEmpty()) {
                Cookie cookie = new Cookie(cookieConfig.get("cookieName"), this.ssoToken);
                cookie.setMaxAge(Integer.parseInt(cookieConfig.get("cookieMaxAge")));
                cookie.setPath(cookieConfig.get("cookiePath"));
                cookie.setDomain(cookieConfig.get("cookieDomain"));
                cookie.setSecure(Boolean.parseBoolean(cookieConfig.get("cookieSecure")));
                response.addCookie(cookie);
            }
            if ((userDataElement = root.element("userData")) != null) {
                Iterator it = userDataElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.userData.put(e.getName(), e.getText());
                }
            }
            if ((accountsElement = root.element("accounts")) != null) {
                Iterator it = accountsElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.accounts.add(e.getText());
                }
            }
            String string = userAuthorizedApps = root.elementTextTrim("userAuthorizedApps") == null ? "" : root.elementTextTrim("userAuthorizedApps");
            if (this.queryAuthorizedApps && !this.isEmpty(userAuthorizedApps)) {
                StringTokenizer commaToker = new StringTokenizer(userAuthorizedApps, "|");
                String[] params = new String[commaToker.countTokens()];
                int i = 0;
                while (i < params.length) {
                    params[i] = commaToker.nextToken();
                    if (!this.isEmpty(params[i])) {
                        // empty if block
                    }
                    this.userAuthorizedApps.add(params[i]);
                    ++i;
                }
            }
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Auth_VerifyV3Cert(String licenseKey, String cipher, String random) {
        Element root;
        block15: {
            Element accountsElement;
            String respResult;
            block14: {
                String respMessage;
                block13: {
                    if (this.isEmpty(this.serverIp)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_IP");
                        this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                        return 1;
                    }
                    if (this.isEmpty(licenseKey) || this.isEmpty(cipher) || this.isEmpty(random)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                        return 1;
                    }
                    StringBuffer reqMessage = new StringBuffer();
                    reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                    reqMessage.append("<sid-auth>");
                    reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                    reqMessage.append("<auth-type>EKeyAuthV3</auth-type>");
                    reqMessage.append("<auth-token>");
                    reqMessage.append("<token-cipher>" + cipher + "</token-cipher>");
                    reqMessage.append("<token-random>" + random + "</token-random>");
                    reqMessage.append("<token-clientIp>" + (this.isEmpty(this.clientIP) ? "" : this.clientIP) + "</token-clientIp>");
                    reqMessage.append("</auth-token>");
                    reqMessage.append("</sid-auth>");
                    MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                    respMessage = messageRequest.sendMessage(reqMessage.toString());
                    if (!this.isEmpty(respMessage)) break block13;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                    return 1;
                }
                Document document = DocumentHelper.parseText((String)respMessage);
                root = document.getRootElement();
                respResult = root.elementTextTrim("result");
                if (respResult != null) break block14;
                this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                return 1;
            }
            if (Integer.parseInt(respResult) != 0) break block15;
            this.passport = root.elementTextTrim("passport");
            this.ssoToken = root.elementTextTrim("ssoToken");
            Element userDataElement = root.element("userData");
            if (userDataElement != null) {
                Iterator it = userDataElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.userData.put(e.getName(), e.getText());
                }
            }
            if ((accountsElement = root.element("accounts")) != null) {
                Iterator it = accountsElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.accounts.add(e.getText());
                }
            }
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Auth_VerifyUserPassword(String licenseKey, String loginName, String password) {
        return this.Auth_VerifyUserPassword(licenseKey, loginName, password, null, null);
    }

    public int Auth_VerifyUserPassword(String licenseKey, String loginName, String password, HttpServletResponse response, Map<String, String> cookieConfig) {
        Element root;
        block20: {
            String userAuthorizedApps;
            Element accountsElement;
            Element userDataElement;
            block21: {
                String respResult;
                block19: {
                    String respMessage;
                    block18: {
                        if (this.isEmpty(this.serverIp)) {
                            this.setErrorCode("ERROR_CODE_EMPTY_IP");
                            this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                            return 1;
                        }
                        if (this.isEmpty(licenseKey) || this.isEmpty(loginName) || this.isEmpty(password)) {
                            this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                            this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                            return 1;
                        }
                        StringBuffer reqMessage = new StringBuffer();
                        reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                        reqMessage.append("<sid-auth>");
                        reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                        reqMessage.append("<auth-type>UserPasswordAuth</auth-type>");
                        reqMessage.append("<auth-queryAuthorizedApps>" + (this.queryAuthorizedApps ? "0" : "1") + "</auth-queryAuthorizedApps>");
                        reqMessage.append("<auth-token>");
                        reqMessage.append("<token-loginName>" + loginName + "</token-loginName>");
                        reqMessage.append("<token-password>" + password + "</token-password>");
                        reqMessage.append("<token-clientIp>" + (this.isEmpty(this.clientIP) ? "" : this.clientIP) + "</token-clientIp>");
                        reqMessage.append("</auth-token>");
                        reqMessage.append("</sid-auth>");
                        MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                        respMessage = messageRequest.sendMessage(reqMessage.toString());
                        if (!this.isEmpty(respMessage)) break block18;
                        this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                        return 1;
                    }
                    Document document = DocumentHelper.parseText((String)respMessage);
                    root = document.getRootElement();
                    respResult = root.elementTextTrim("result");
                    if (respResult != null) break block19;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                    return 1;
                }
                if (Integer.parseInt(respResult) != 0) break block20;
                if (response == null || cookieConfig == null || cookieConfig.isEmpty() || !this.isEmpty(cookieConfig.get("cookieMaxAge")) && !this.isEmpty(cookieConfig.get("cookiePath")) && !this.isEmpty(cookieConfig.get("cookieName")) && !this.isEmpty(cookieConfig.get("cookieSecure")) && !this.isEmpty(cookieConfig.get("cookieDomain"))) break block21;
                this.setErrorCode("ERROR_CODE_COOKIE_CONFIG");
                this.setErrorMsg("Cookie\u8bbe\u7f6e\u53c2\u6570\u9519\u8bef!");
                return 1;
            }
            this.passport = root.elementTextTrim("passport");
            this.ssoToken = root.elementTextTrim("ssoToken");
            if (response != null && cookieConfig != null && !cookieConfig.isEmpty()) {
                Cookie cookie = new Cookie(cookieConfig.get("cookieName"), this.ssoToken);
                cookie.setMaxAge(Integer.parseInt(cookieConfig.get("cookieMaxAge")));
                cookie.setPath(cookieConfig.get("cookiePath"));
                cookie.setDomain(cookieConfig.get("cookieDomain"));
                cookie.setSecure(Boolean.parseBoolean(cookieConfig.get("cookieSecure")));
                response.addCookie(cookie);
            }
            if ((userDataElement = root.element("userData")) != null) {
                Iterator it = userDataElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.userData.put(e.getName(), e.getText());
                }
            }
            if ((accountsElement = root.element("accounts")) != null) {
                Iterator it = accountsElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.accounts.add(e.getText());
                }
            }
            String string = userAuthorizedApps = root.elementTextTrim("userAuthorizedApps") == null ? "" : root.elementTextTrim("userAuthorizedApps");
            if (this.queryAuthorizedApps && !this.isEmpty(userAuthorizedApps)) {
                StringTokenizer commaToker = new StringTokenizer(userAuthorizedApps, "|");
                String[] params = new String[commaToker.countTokens()];
                int i = 0;
                while (i < params.length) {
                    params[i] = commaToker.nextToken();
                    if (!this.isEmpty(params[i])) {
                        // empty if block
                    }
                    this.userAuthorizedApps.add(params[i]);
                    ++i;
                }
            }
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Auth_VerifyTempPassword(String licenseKey, String loginName, String password) {
        Element root;
        block16: {
            String userAuthorizedApps;
            String respResult;
            block15: {
                String respMessage;
                block14: {
                    if (this.isEmpty(this.serverIp)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_IP");
                        this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                        return 1;
                    }
                    if (this.isEmpty(licenseKey) || this.isEmpty(loginName) || this.isEmpty(password)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                        return 1;
                    }
                    StringBuffer reqMessage = new StringBuffer();
                    reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                    reqMessage.append("<sid-auth>");
                    reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                    reqMessage.append("<auth-type>TempPasswordAuth</auth-type>");
                    reqMessage.append("<auth-queryAuthorizedApps>" + (this.queryAuthorizedApps ? "0" : "1") + "</auth-queryAuthorizedApps>");
                    reqMessage.append("<auth-token>");
                    reqMessage.append("<token-loginName>" + loginName + "</token-loginName>");
                    reqMessage.append("<token-password>" + password + "</token-password>");
                    reqMessage.append("<token-clientIp>" + (this.isEmpty(this.clientIP) ? "" : this.clientIP) + "</token-clientIp>");
                    reqMessage.append("</auth-token>");
                    reqMessage.append("</sid-auth>");
                    MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                    respMessage = messageRequest.sendMessage(reqMessage.toString());
                    if (!this.isEmpty(respMessage)) break block14;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                    return 1;
                }
                Document document = DocumentHelper.parseText((String)respMessage);
                root = document.getRootElement();
                respResult = root.elementTextTrim("result");
                if (respResult != null) break block15;
                this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                return 1;
            }
            if (Integer.parseInt(respResult) != 0) break block16;
            this.passport = root.elementTextTrim("passport");
            this.ssoToken = root.elementTextTrim("ssoToken");
            Element accountsElement = root.element("accounts");
            if (accountsElement != null) {
                Iterator it = accountsElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.accounts.add(e.getText());
                }
            }
            String string = userAuthorizedApps = root.elementTextTrim("userAuthorizedApps") == null ? "" : root.elementTextTrim("userAuthorizedApps");
            if (this.queryAuthorizedApps && !this.isEmpty(userAuthorizedApps)) {
                StringTokenizer commaToker = new StringTokenizer(userAuthorizedApps, "|");
                String[] params = new String[commaToker.countTokens()];
                int i = 0;
                while (i < params.length) {
                    params[i] = commaToker.nextToken();
                    if (!this.isEmpty(params[i])) {
                        // empty if block
                    }
                    this.userAuthorizedApps.add(params[i]);
                    ++i;
                }
            }
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Auth_VerifyLdapPassword(String licenseKey, String loginName, String password) {
        Element root;
        block18: {
            String userAuthorizedApps;
            Element accountsElement;
            String respResult;
            block17: {
                String respMessage;
                block16: {
                    if (this.isEmpty(this.serverIp)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_IP");
                        this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                        return 1;
                    }
                    if (this.isEmpty(licenseKey) || this.isEmpty(loginName) || this.isEmpty(password)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                        return 1;
                    }
                    StringBuffer reqMessage = new StringBuffer();
                    reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                    reqMessage.append("<sid-auth>");
                    reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                    reqMessage.append("<auth-type>LDAPPasswordAuth</auth-type>");
                    reqMessage.append("<auth-queryAuthorizedApps>" + (this.queryAuthorizedApps ? "0" : "1") + "</auth-queryAuthorizedApps>");
                    reqMessage.append("<auth-token>");
                    reqMessage.append("<token-loginName>" + loginName + "</token-loginName>");
                    reqMessage.append("<token-password>" + password + "</token-password>");
                    reqMessage.append("<token-clientIp>" + (this.isEmpty(this.clientIP) ? "" : this.clientIP) + "</token-clientIp>");
                    reqMessage.append("</auth-token>");
                    reqMessage.append("</sid-auth>");
                    MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                    respMessage = messageRequest.sendMessage(reqMessage.toString());
                    if (!this.isEmpty(respMessage)) break block16;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                    return 1;
                }
                Document document = DocumentHelper.parseText((String)respMessage);
                root = document.getRootElement();
                respResult = root.elementTextTrim("result");
                if (respResult != null) break block17;
                this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                return 1;
            }
            if (Integer.parseInt(respResult) != 0) break block18;
            this.passport = root.elementTextTrim("passport");
            this.ssoToken = root.elementTextTrim("ssoToken");
            Element userDataElement = root.element("userData");
            if (userDataElement != null) {
                Iterator it = userDataElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.userData.put(e.getName(), e.getText());
                }
            }
            if ((accountsElement = root.element("accounts")) != null) {
                Iterator it = accountsElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.accounts.add(e.getText());
                }
            }
            String string = userAuthorizedApps = root.elementTextTrim("userAuthorizedApps") == null ? "" : root.elementTextTrim("userAuthorizedApps");
            if (this.queryAuthorizedApps && !this.isEmpty(userAuthorizedApps)) {
                StringTokenizer commaToker = new StringTokenizer(userAuthorizedApps, "|");
                String[] params = new String[commaToker.countTokens()];
                int i = 0;
                while (i < params.length) {
                    params[i] = commaToker.nextToken();
                    if (!this.isEmpty(params[i])) {
                        // empty if block
                    }
                    this.userAuthorizedApps.add(params[i]);
                    ++i;
                }
            }
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Security_UpdatePIN(String licenseKey, String serialNumber) {
        Element root;
        block11: {
            String respResult;
            block10: {
                String respMessage;
                block9: {
                    if (this.isEmpty(this.serverIp)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_IP");
                        this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                        return 1;
                    }
                    if (this.isEmpty(licenseKey) || this.isEmpty(serialNumber)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                        return 1;
                    }
                    StringBuffer reqMessage = new StringBuffer();
                    reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                    reqMessage.append("<sid-security>");
                    reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                    reqMessage.append("<security-type>updatePIN</security-type>");
                    reqMessage.append("<security-token>");
                    reqMessage.append("<token-serialNumber>" + serialNumber + "</token-serialNumber>");
                    reqMessage.append("</security-token>");
                    reqMessage.append("</sid-security>");
                    MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                    respMessage = messageRequest.sendMessage(reqMessage.toString());
                    if (!this.isEmpty(respMessage)) break block9;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                    return 1;
                }
                Document document = DocumentHelper.parseText((String)respMessage);
                root = document.getRootElement();
                respResult = root.elementTextTrim("result");
                if (respResult != null) break block10;
                this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                return 1;
            }
            if (Integer.parseInt(respResult) != 0) break block11;
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Security_SendSMSCode(String licenseKey, String uniqueIdentify, String identifyValue) {
        Element root;
        block11: {
            String respResult;
            block10: {
                String respMessage;
                block9: {
                    if (this.isEmpty(this.serverIp)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_IP");
                        this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                        return 1;
                    }
                    if (this.isEmpty(licenseKey) || this.isEmpty(uniqueIdentify) || this.isEmpty(identifyValue)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                        return 1;
                    }
                    StringBuffer reqMessage = new StringBuffer();
                    reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                    reqMessage.append("<sid-security>");
                    reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                    reqMessage.append("<app-code>" + (this.isEmpty(this.proxyAppCode) ? licenseKey : this.proxyAppCode) + "</app-code>");
                    reqMessage.append("<security-type>sendSMSCode</security-type>");
                    reqMessage.append("<security-token>");
                    reqMessage.append("<token-uniqueIdentify>" + uniqueIdentify + "</token-uniqueIdentify>");
                    reqMessage.append("<token-identifyValue>" + identifyValue + "</token-identifyValue>");
                    reqMessage.append("</security-token>");
                    reqMessage.append("</sid-security>");
                    MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                    respMessage = messageRequest.sendMessage(reqMessage.toString());
                    if (!this.isEmpty(respMessage)) break block9;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                    return 1;
                }
                Document document = DocumentHelper.parseText((String)respMessage);
                root = document.getRootElement();
                respResult = root.elementTextTrim("result");
                if (respResult != null) break block10;
                this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                return 1;
            }
            if (Integer.parseInt(respResult) != 0) break block11;
            this.sequenceID = root.elementTextTrim("sequenceID");
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Security_GetSSOToken(String licenseKey, String uniqueIdentify, String identifyValue) {
        return this.Security_GetSSOToken(licenseKey, uniqueIdentify, identifyValue, null, null);
    }

    public int Security_GetSSOToken(String licenseKey, String uniqueIdentify, String identifyValue, HttpServletResponse response, Map<String, String> cookieConfig) {
        Element root;
        block13: {
            block14: {
                String respResult;
                block12: {
                    String respMessage;
                    block11: {
                        if (this.isEmpty(this.serverIp)) {
                            this.setErrorCode("ERROR_CODE_EMPTY_IP");
                            this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                            return 1;
                        }
                        if (this.isEmpty(licenseKey) || this.isEmpty(uniqueIdentify) || this.isEmpty(identifyValue)) {
                            this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                            this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                            return 1;
                        }
                        StringBuffer reqMessage = new StringBuffer();
                        reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                        reqMessage.append("<sid-security>");
                        reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                        reqMessage.append("<security-type>getSSOToken</security-type>");
                        reqMessage.append("<security-token>");
                        reqMessage.append("<token-uniqueIdentify>" + uniqueIdentify + "</token-uniqueIdentify>");
                        reqMessage.append("<token-identifyValue>" + identifyValue + "</token-identifyValue>");
                        reqMessage.append("</security-token>");
                        reqMessage.append("</sid-security>");
                        MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                        respMessage = messageRequest.sendMessage(reqMessage.toString());
                        if (!this.isEmpty(respMessage)) break block11;
                        this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                        return 1;
                    }
                    Document document = DocumentHelper.parseText((String)respMessage);
                    root = document.getRootElement();
                    respResult = root.elementTextTrim("result");
                    if (respResult != null) break block12;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                    return 1;
                }
                if (Integer.parseInt(respResult) != 0) break block13;
                if (response == null || cookieConfig == null || cookieConfig.isEmpty() || !this.isEmpty(cookieConfig.get("cookieMaxAge")) && !this.isEmpty(cookieConfig.get("cookiePath")) && !this.isEmpty(cookieConfig.get("cookieName")) && !this.isEmpty(cookieConfig.get("cookieSecure")) && !this.isEmpty(cookieConfig.get("cookieDomain"))) break block14;
                this.setErrorCode("ERROR_CODE_COOKIE_CONFIG");
                this.setErrorMsg("Cookie\u8bbe\u7f6e\u53c2\u6570\u9519\u8bef!");
                return 1;
            }
            this.ssoToken = root.elementTextTrim("ssoToken");
            if (response != null && cookieConfig != null && !cookieConfig.isEmpty()) {
                Cookie cookie = new Cookie(cookieConfig.get("cookieName"), this.ssoToken);
                cookie.setMaxAge(Integer.parseInt(cookieConfig.get("cookieMaxAge")));
                cookie.setPath(cookieConfig.get("cookiePath"));
                cookie.setDomain(cookieConfig.get("cookieDomain"));
                cookie.setSecure(Boolean.parseBoolean(cookieConfig.get("cookieSecure")));
                response.addCookie(cookie);
            }
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Auth_VerifySMSCode(String licenseKey, String uniqueIdentify, String identifyValue, String sequenceID, String smsCode) {
        return this.Auth_VerifySMSCode(licenseKey, uniqueIdentify, identifyValue, sequenceID, smsCode, false, null);
    }

    public int Auth_VerifySMSCode(String licenseKey, String uniqueIdentify, String identifyValue, String sequenceID, String smsCode, boolean verifyUserPassword, String userPassword) {
        Element root;
        block21: {
            String userAuthorizedApps;
            Element accountsElement;
            String respResult;
            block20: {
                String respMessage;
                block19: {
                    if (this.isEmpty(this.serverIp)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_IP");
                        this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                        return 1;
                    }
                    if (this.isEmpty(licenseKey) || this.isEmpty(uniqueIdentify) || this.isEmpty(identifyValue) || this.isEmpty(sequenceID) || this.isEmpty(smsCode)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                        return 1;
                    }
                    if (verifyUserPassword && this.isEmpty(userPassword)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                        return 1;
                    }
                    StringBuffer reqMessage = new StringBuffer();
                    reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                    reqMessage.append("<sid-auth>");
                    reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                    reqMessage.append("<app-code>" + (this.isEmpty(this.proxyAppCode) ? licenseKey : this.proxyAppCode) + "</app-code>");
                    reqMessage.append("<auth-type>SMSCodeAuth</auth-type>");
                    reqMessage.append("<auth-queryAuthorizedApps>" + (this.queryAuthorizedApps ? "0" : "1") + "</auth-queryAuthorizedApps>");
                    reqMessage.append("<auth-token>");
                    reqMessage.append("<token-uniqueIdentify>" + uniqueIdentify + "</token-uniqueIdentify>");
                    reqMessage.append("<token-identifyValue>" + identifyValue + "</token-identifyValue>");
                    reqMessage.append("<token-sequenceID>" + sequenceID + "</token-sequenceID>");
                    reqMessage.append("<token-smsCode>" + smsCode + "</token-smsCode>");
                    if (verifyUserPassword) {
                        reqMessage.append("<token-userPassword>" + userPassword + "</token-userPassword>");
                    } else {
                        reqMessage.append("<token-userPassword></token-userPassword>");
                    }
                    reqMessage.append("<token-clientIp>" + (this.isEmpty(this.clientIP) ? "" : this.clientIP) + "</token-clientIp>");
                    reqMessage.append("</auth-token>");
                    reqMessage.append("</sid-auth>");
                    MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                    respMessage = messageRequest.sendMessage(reqMessage.toString());
                    if (!this.isEmpty(respMessage)) break block19;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                    return 1;
                }
                Document document = DocumentHelper.parseText((String)respMessage);
                root = document.getRootElement();
                respResult = root.elementTextTrim("result");
                if (respResult != null) break block20;
                this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                return 1;
            }
            if (Integer.parseInt(respResult) != 0) break block21;
            this.passport = root.elementTextTrim("passport");
            this.ssoToken = root.elementTextTrim("ssoToken");
            Element userDataElement = root.element("userData");
            if (userDataElement != null) {
                Iterator it = userDataElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.userData.put(e.getName(), e.getText());
                }
            }
            if ((accountsElement = root.element("accounts")) != null) {
                Iterator it = accountsElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.accounts.add(e.getText());
                }
            }
            String string = userAuthorizedApps = root.elementTextTrim("userAuthorizedApps") == null ? "" : root.elementTextTrim("userAuthorizedApps");
            if (this.queryAuthorizedApps && !this.isEmpty(userAuthorizedApps)) {
                StringTokenizer commaToker = new StringTokenizer(userAuthorizedApps, "|");
                String[] params = new String[commaToker.countTokens()];
                int i = 0;
                while (i < params.length) {
                    params[i] = commaToker.nextToken();
                    if (!this.isEmpty(params[i])) {
                        // empty if block
                    }
                    this.userAuthorizedApps.add(params[i]);
                    ++i;
                }
            }
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Security_VerifyTicket(String licenseKey, String ticket) {
        Element root;
        block24: {
            String userAuthorizedApps;
            String respResult;
            block23: {
                String respMessage;
                block22: {
                    if (this.isEmpty(this.serverIp)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_IP");
                        this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                        return 1;
                    }
                    if (this.isEmpty(licenseKey) || this.isEmpty(ticket)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                        return 1;
                    }
                    if (ticket.startsWith("DT-")) {
                        try {
                            ticket = ticket.substring(3);
                            ticket = new String(new BASE64Decoder().decodeBuffer(ticket));
                            String serverInfo = ticket.substring(0, ticket.indexOf("|"));
                            StringTokenizer strToken = new StringTokenizer(serverInfo, ":");
                            String[] params = new String[strToken.countTokens()];
                            int i = 0;
                            while (i < params.length) {
                                params[i] = strToken.nextToken();
                                ++i;
                            }
                            if (params != null && (params.length == 3 || params.length == 4)) {
                                if (!this.isEmpty(params[0]) && !this.communicationProtocol.equals(params[0])) {
                                    this.communicationProtocol = params[0];
                                }
                                if (!this.isEmpty(params[1]) && !this.serverIp.equals(params[1])) {
                                    this.serverIp = params[1];
                                }
                                int n = this.serverPort = !this.isEmpty(params[2]) ? Integer.parseInt(params[2]) : 80;
                                if (params.length == 4 && !this.isEmpty(params[3]) && !this.serverName.equals(params[3])) {
                                    this.serverName = params[3];
                                }
                            }
                            ticket = ticket.substring(ticket.indexOf("|") + 1);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            this.setErrorCode("ERROR_CODE_TICKET_FORMAT_ERROR");
                            this.setErrorMsg("\u7968\u636e\u683c\u5f0f\u6216\u5185\u5bb9\u4e0d\u6b63\u786e!");
                            return 1;
                        }
                    }
                    StringBuffer reqMessage = new StringBuffer();
                    reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                    reqMessage.append("<sid-verify>");
                    reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                    reqMessage.append("<verify-type>ticket</verify-type>");
                    reqMessage.append("<verify-queryAuthorizedApps>" + (this.queryAuthorizedApps ? "0" : "1") + "</verify-queryAuthorizedApps>");
                    reqMessage.append("<verify-ticket>");
                    reqMessage.append("<ticket>" + ticket + "</ticket>");
                    reqMessage.append("</verify-ticket>");
                    reqMessage.append("</sid-verify>");
                    MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                    respMessage = messageRequest.sendMessage(reqMessage.toString());
                    if (!this.isEmpty(respMessage)) break block22;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                    return 1;
                }
                Document document = DocumentHelper.parseText((String)respMessage);
                root = document.getRootElement();
                respResult = root.elementTextTrim("result");
                if (respResult != null) break block23;
                this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                return 1;
            }
            if (Integer.parseInt(respResult) != 0) break block24;
            this.passport = root.elementTextTrim("passport");
            Element userDataElement = root.element("userData");
            if (userDataElement != null) {
                Iterator it = userDataElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.userData.put(e.getName(), e.getText());
                }
            }
            String string = userAuthorizedApps = root.elementTextTrim("userAuthorizedApps") == null ? "" : root.elementTextTrim("userAuthorizedApps");
            if (this.queryAuthorizedApps && !this.isEmpty(userAuthorizedApps)) {
                StringTokenizer commaToker = new StringTokenizer(userAuthorizedApps, "|");
                String[] params = new String[commaToker.countTokens()];
                int i = 0;
                while (i < params.length) {
                    params[i] = commaToker.nextToken();
                    if (!this.isEmpty(params[i])) {
                        // empty if block
                    }
                    this.userAuthorizedApps.add(params[i]);
                    ++i;
                }
            }
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Security_VerifySign(String licenseKey, String cert, String plain, String signature) {
        Element root;
        block11: {
            String respResult;
            block10: {
                String respMessage;
                block9: {
                    if (this.isEmpty(this.serverIp)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_IP");
                        this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                        return 1;
                    }
                    if (this.isEmpty(licenseKey) || this.isEmpty(cert) || this.isEmpty(plain) || this.isEmpty(signature)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                        return 1;
                    }
                    StringBuffer reqMessage = new StringBuffer();
                    reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                    reqMessage.append("<sid-verify>");
                    reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                    reqMessage.append("<verify-type>signature</verify-type>");
                    reqMessage.append("<verify-sign>");
                    reqMessage.append("<sign-cert>" + cert + "</sign-cert>");
                    reqMessage.append("<sign-plain>" + plain + "</sign-plain>");
                    reqMessage.append("<sign-signature>" + signature + "</sign-signature>");
                    reqMessage.append("</verify-sign>");
                    reqMessage.append("</sid-verify>");
                    MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                    respMessage = messageRequest.sendMessage(reqMessage.toString());
                    if (!this.isEmpty(respMessage)) break block9;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                    return 1;
                }
                Document document = DocumentHelper.parseText((String)respMessage);
                root = document.getRootElement();
                respResult = root.elementTextTrim("result");
                if (respResult != null) break block10;
                this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                return 1;
            }
            if (Integer.parseInt(respResult) != 0) break block11;
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Security_VerifyClientTicket(String licenseKey, String ticket) {
        Element root;
        block16: {
            String userAuthorizedApps;
            String respResult;
            block15: {
                String respMessage;
                block14: {
                    if (this.isEmpty(this.serverIp)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_IP");
                        this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                        return 1;
                    }
                    if (this.isEmpty(licenseKey) || this.isEmpty(ticket)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                        return 1;
                    }
                    StringBuffer reqMessage = new StringBuffer();
                    reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                    reqMessage.append("<sid-verify>");
                    reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                    reqMessage.append("<verify-type>clientTicket</verify-type>");
                    reqMessage.append("<verify-queryAuthorizedApps>" + (this.queryAuthorizedApps ? "0" : "1") + "</verify-queryAuthorizedApps>");
                    reqMessage.append("<verify-clientTicket>");
                    reqMessage.append("<ticket>" + ticket + "</ticket>");
                    reqMessage.append("</verify-clientTicket>");
                    reqMessage.append("</sid-verify>");
                    MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                    respMessage = messageRequest.sendMessage(reqMessage.toString());
                    if (!this.isEmpty(respMessage)) break block14;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                    return 1;
                }
                Document document = DocumentHelper.parseText((String)respMessage);
                root = document.getRootElement();
                respResult = root.elementTextTrim("result");
                if (respResult != null) break block15;
                this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                return 1;
            }
            if (Integer.parseInt(respResult) != 0) break block16;
            this.passport = root.elementTextTrim("passport");
            Element accountsElement = root.element("accounts");
            if (accountsElement != null) {
                Iterator it = accountsElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.accounts.add(e.getText());
                }
            }
            String string = userAuthorizedApps = root.elementTextTrim("userAuthorizedApps") == null ? "" : root.elementTextTrim("userAuthorizedApps");
            if (this.queryAuthorizedApps && !this.isEmpty(userAuthorizedApps)) {
                StringTokenizer commaToker = new StringTokenizer(userAuthorizedApps, "|");
                String[] params = new String[commaToker.countTokens()];
                int i = 0;
                while (i < params.length) {
                    params[i] = commaToker.nextToken();
                    if (!this.isEmpty(params[i])) {
                        // empty if block
                    }
                    this.userAuthorizedApps.add(params[i]);
                    ++i;
                }
            }
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    public int Security_VerifyWebToken(String licenseKey, String token) {
        Element root;
        block16: {
            String userAuthorizedApps;
            String respResult;
            block15: {
                String respMessage;
                block14: {
                    if (this.isEmpty(this.serverIp)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_IP");
                        this.setErrorMsg("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2dip\u5730\u5740/\u7aef\u53e3\u53f7\u662f\u5426\u586b\u5199\u6b63\u786e,\u5e76\u786e\u4fdd\u8fdc\u7a0b\u670d\u52a1\u5668\u5df2\u7ecf\u542f\u7528.");
                        return 1;
                    }
                    if (this.isEmpty(licenseKey) || this.isEmpty(token)) {
                        this.setErrorCode("ERROR_CODE_EMPTY_PARAMS");
                        this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
                        return 1;
                    }
                    StringBuffer reqMessage = new StringBuffer();
                    reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
                    reqMessage.append("<sid-verify>");
                    reqMessage.append("<licenseKey>" + licenseKey + "</licenseKey>");
                    reqMessage.append("<verify-type>webToken</verify-type>");
                    reqMessage.append("<verify-queryAuthorizedApps>" + (this.queryAuthorizedApps ? "0" : "1") + "</verify-queryAuthorizedApps>");
                    reqMessage.append("<verify-webToken>");
                    reqMessage.append("<token>" + token + "</token>");
                    reqMessage.append("</verify-webToken>");
                    reqMessage.append("</sid-verify>");
                    MessageRequest messageRequest = new MessageRequest(this.serverIp, this.serverPort, this.serverName, this.communicationProtocol, this.charset);
                    respMessage = messageRequest.sendMessage(reqMessage.toString());
                    if (!this.isEmpty(respMessage)) break block14;
                    this.setErrorCode("ERROR_CODE_EMPTY_RESPONSE");
                    this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a.");
                    return 1;
                }
                Document document = DocumentHelper.parseText((String)respMessage);
                root = document.getRootElement();
                respResult = root.elementTextTrim("result");
                if (respResult != null) break block15;
                this.setErrorCode("ERROR_CODE_EMPTY_RESULT_NODE");
                this.setErrorMsg("\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fe1\u606f\u72b6\u6001\u8282\u70b9\u4e3a\u7a7a!");
                return 1;
            }
            if (Integer.parseInt(respResult) != 0) break block16;
            this.passport = root.elementTextTrim("passport");
            Element accountsElement = root.element("accounts");
            if (accountsElement != null) {
                Iterator it = accountsElement.elementIterator();
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    this.accounts.add(e.getText());
                }
            }
            String string = userAuthorizedApps = root.elementTextTrim("userAuthorizedApps") == null ? "" : root.elementTextTrim("userAuthorizedApps");
            if (this.queryAuthorizedApps && !this.isEmpty(userAuthorizedApps)) {
                StringTokenizer commaToker = new StringTokenizer(userAuthorizedApps, "|");
                String[] params = new String[commaToker.countTokens()];
                int i = 0;
                while (i < params.length) {
                    params[i] = commaToker.nextToken();
                    if (!this.isEmpty(params[i])) {
                        // empty if block
                    }
                    this.userAuthorizedApps.add(params[i]);
                    ++i;
                }
            }
            return 0;
        }
        try {
            String errorCode = root.elementTextTrim("errorCode");
            this.setErrorCode(errorCode);
            String errorMsg = root.elementTextTrim("errorMsg");
            this.setErrorMsg(errorMsg);
            return 1;
        }
        catch (EncoderException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u7f16\u7801\u901a\u4fe1\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_REQUEST_EXCEPTION");
            this.setErrorMsg("\u8fde\u63a5\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25\u6216\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u4fe1\u606f!");
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.setErrorCode("ERROR_CODE_PARSE_RESPONSE");
            this.setErrorMsg("\u89e3\u6790\u8fd4\u56de\u4fe1\u606f\u5931\u8d25!");
            return 1;
        }
    }

    private boolean isEmpty(String input) {
        return input == null || input.trim().length() <= 0;
    }

    public void setServerName(String serverName) {
        if (!this.isEmpty(serverName)) {
            this.serverName = serverName;
        }
    }

    public void setCommunicationProtocol(String communicationProtocol) {
        this.communicationProtocol = this.isEmpty(communicationProtocol) || !communicationProtocol.equals("socket") && !communicationProtocol.equals("http") ? "http" : communicationProtocol;
    }

    public void setCharset(String charset) {
        this.charset = this.isEmpty(charset) || !charset.equals("GBK") && !charset.equals("UTF-8") ? "GBK" : charset;
    }

    public void setQueryAuthorizedApps(boolean queryAuthorizedApps) {
        this.queryAuthorizedApps = queryAuthorizedApps;
    }

    public void setProxyAppCode(String proxyAppCode) {
        this.proxyAppCode = proxyAppCode;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public String getPassport() {
        return this.passport;
    }

    public String getSSOToken() {
        return this.ssoToken;
    }

    public String getUserData(String key) {
        if (this.userData == null || this.userData.isEmpty()) {
            return null;
        }
        if (!this.userData.containsKey(key)) {
            return null;
        }
        return this.userData.get(key);
    }

    public List<String> getAccounts() {
        return this.accounts;
    }

    public List<String> getUserAuthorizedApps() {
        return this.userAuthorizedApps;
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public String getErrorCode() {
        return this.isEmpty(this.errorCode) ? "" : this.errorCode;
    }

    private void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return this.isEmpty(this.errorMsg) ? "" : this.errorMsg;
    }

    private void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}

