package com.shr.filter;

import com.shr.config.ThreadLocalConfig;
import org.eetrust.security.client.util.AssertionHolder;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;

/**
 * @author Inori
 */
@WebFilter(urlPatterns = "/*")
public class SecurityFilter implements Filter {
    public static final String SUBJECT_USER = "_subject_user_";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        // 转换参数
        final HttpServletRequest request = (HttpServletRequest) servletRequest;

        final HttpServletResponse response = (HttpServletResponse) servletResponse;
        final HttpSession session = request.getSession(false);
        if (session == null) {
            //response.sendRedirect(request.getContextPath() + "/accessDenied.jsp");
            return;
        }

        // 取得会话中登录用户
        String user = (String) session.getAttribute(SUBJECT_USER);
        if (user == null) {
            user = AssertionHolder.getAssertion().getPrincipal().getName();
            if (user == null) {
                //response.sendRedirect(request.getContextPath() + "/accessDenied.jsp");
                return;
            }

            ThreadLocalConfig.get().put("ssoUsername", user);

            request.getSession().setAttribute(SUBJECT_USER, user);
        }

        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void destroy() {
    }


}
