/*
 * Decompiled with CFR 0.152.
 */
package org.eetrust.security.client.util;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eetrust.security.client.core.AbstractConfigurationFilter;
import org.eetrust.security.client.util.AssertionHolder;
import org.eetrust.security.client.util.PathMatcher;
import org.eetrust.security.client.util.URLPathMatcher;
import org.eetrust.security.client.validation.Assertion;

public final class AssertionThreadLocalFilter
extends AbstractConfigurationFilter {
    private static final PathMatcher pathMatcher = new URLPathMatcher();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String[] excludeInterceptURL;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession(false);
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String url = request.getRequestURI();
        int firstQuestionMarkIndex = url.indexOf("?");
        if (firstQuestionMarkIndex != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        if ((excludeInterceptURL = this.getExcludeInterceptURL()) != null && excludeInterceptURL.length > 0) {
            int i = 0;
            while (i < excludeInterceptURL.length) {
                boolean matched = pathMatcher.match(excludeInterceptURL[i], url);
                if (matched) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                ++i;
            }
        }
        Assertion assertion = (Assertion)(session == null ? request.getAttribute("_const_uap_assertion_") : session.getAttribute("_const_uap_assertion_"));
        try {
            AssertionHolder.setAssertion(assertion);
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            AssertionHolder.clear();
        }
    }

    public void destroy() {
    }
}

