package com.shr.api;

import com.kingdee.shr.api.Response;
import com.kingdee.shr.api.SHRClient;
import com.shr.exception.ShrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;

/**
 * @author Inori
 */
@Component
public class CallShrOsfApi {

    private static final Logger log = LoggerFactory.getLogger(CallShrOsfApi.class);

    private String serverUrl;

    public CallShrOsfApi() {
        serverUrl = "http://192.168.0.119:6888/shr";
    }

    public Response callShrOsf(String serviceName, Map<String, Object> param) {
        SHRClient shrClient = new SHRClient();
        try {
            Response response = shrClient.executeService(serverUrl, serviceName, param);
            log.info("SHR返回结果: {}", response);
            return response;
        } catch (IOException e) {
            e.printStackTrace();
            throw new ShrException("SHR返回异常: " + e.getMessage());
        }
    }


}
