package com.shr.controller;

import com.shr.annotion.AccessLog;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IAdminOrgService;
import com.shr.transfer.adminorg.AdminOrgInVo;
import com.shr.transfer.adminorg.AdminOrgListInVo;
import com.shr.transfer.adminorg.AdminOrgListOutVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class AdminOrgController {

    @Autowired
    private IAdminOrgService adminOrgService;


    @AccessLog("组织列表")
    @PostMapping("/admin/org/list")
    public RestResponse adminOrgList(@RequestBody(required = true) @Validated AdminOrgListInVo inVo) {
        AdminOrgListOutVo outVo = adminOrgService.adminOrgList(inVo);
        return RestResponse.success(outVo);
    }

    @AccessLog("组织录入")
    @PostMapping("/admin/org/add")
    public RestResponse adminOrgAdd(@RequestBody(required = true) @Validated AdminOrgInVo inVo) {
        return adminOrgService.adminOrgAddOrUpdate(inVo);
    }

    @AccessLog("组织编辑")
    @PostMapping("/admin/org/update")
    public RestResponse adminOrgUpdate(@RequestBody(required = true) @Validated AdminOrgInVo inVo) {
        return adminOrgService.adminOrgAddOrUpdate(inVo);
    }


}
