package com.shr.dao;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.shr.model.Log;
import com.shr.transfer.log.LogListInVo;
import com.shr.transfer.log.LogListOutVoRecords;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface LogMapper extends BaseMapper<Log> {

    /**
     * 日志列表
     *
     * @param inVo 条件
     * @return 列表
     */
    List<LogListOutVoRecords> logList(@Param("inVo") LogListInVo inVo);

    /**
     * 创建日志
     *
     * @param log 日志
     */
    void createLog(Log log);

    /**
     * 是否存在表
     *
     * @return 0-不存在 1-已存在
     */
    Integer isTable();

    /**
     * 创建日志表
     */
    void createTable();


}
