package com.shr.serivce;

import com.shr.common.response.RestResponse;
import com.shr.transfer.employee.*;

/**
 * @author Inori
 */
public interface IEmployeeService {

    /**
     * 员工列表
     *
     * @param inVo 条件
     * @return 列表
     */
    EmployeeListOutVo employeeList(EmployeeListInVo inVo);

    /**
     * 员工任职列表
     *
     * @param inVo 条件
     * @return 列表
     */
    EmployeeEmploymentListOutVo employeeEmploymentList(EmployeeEmploymentListInVo inVo);

    /**
     * 员工入职
     *
     * @param inVo 数据
     * @return 返回结果
     */
    RestResponse employeeInduction(EmployeeInductionInVo inVo);

    /**
     * 员工调动
     *
     * @param inVo 数据
     * @return 返回结果
     */
    RestResponse employeeTransfer(EmployeeTransferInVo inVo);

    /**
     * 员工离职
     *
     * @param inVo 数据
     * @return 返回结果
     */
    RestResponse employeeTurnover(EmployeeTurnoverInVo inVo);


}
