/*
 * Decompiled with CFR 0.152.
 */
package org.eetrust.security.client.session;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eetrust.security.client.core.AbstractConfigurationFilter;
import org.eetrust.security.client.session.SessionMappingStorage;
import org.eetrust.security.client.session.SingleSignOutHandler;
import org.eetrust.security.client.util.PathMatcher;
import org.eetrust.security.client.util.URLPathMatcher;

public final class SingleSignOutFilter
extends AbstractConfigurationFilter {
    private static Log log = LogFactory.getLog(SingleSignOutFilter.class);
    private static final SingleSignOutHandler handler = new SingleSignOutHandler();
    private static final PathMatcher pathMatcher = new URLPathMatcher();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (!this.isIgnoreInitConfiguration()) {
            handler.setTicketParameterName(this.getPropertyFromInitParams(filterConfig, "ticketParameterName", "ticket"));
            handler.setLogoutParameterName(this.getPropertyFromInitParams(filterConfig, "logoutParameterName", "logoutRequest"));
        }
        handler.init();
    }

    public void setTicketParameterName(String name) {
        handler.setTicketParameterName(name);
    }

    public void setLogoutParameterName(String name) {
        handler.setLogoutParameterName(name);
    }

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        handler.setSessionMappingStorage(storage);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String[] excludeInterceptURL;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String url = request.getRequestURI();
        int firstQuestionMarkIndex = url.indexOf("?");
        if (firstQuestionMarkIndex != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        if ((excludeInterceptURL = this.getExcludeInterceptURL()) != null && excludeInterceptURL.length > 0) {
            int i = 0;
            while (i < excludeInterceptURL.length) {
                boolean matched = pathMatcher.match(excludeInterceptURL[i], url);
                if (matched) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                ++i;
            }
        }
        if (handler.isTokenRequest(request)) {
            handler.recordSession(request);
        } else {
            if (handler.isLogoutRequest(request)) {
                handler.destroySession(request);
                return;
            }
            log.trace((Object)("Ignoring URI " + request.getRequestURI()));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    protected static SingleSignOutHandler getSingleSignOutHandler() {
        return handler;
    }
}

