package com.shr.controller;

import com.kingdee.shr.sso.client.ltpa.LtpaTokenManager;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;

/**
 * @author Lnori
 */
@RestController
@RequestMapping("/api")
public class EasController {

    @GetMapping(value = "/eas/ssoLogin")
    public void ssoLogin(HttpServletResponse response) throws IOException {
        response.sendRedirect(loginEasportal());
    }

    public static String loginEasportal() {
        //从EAS服务器上下载     server\profiles\server(1...n)\config\portalConfig\LtpaToken.properties
        File file2 = new File("src/main/resources/LtpaToken.properties");
        String configPath = file2.getAbsolutePath();

        //要跳转的url '//'代表首页
        String redirectTo = "//";
        //调用LtpaTokenManager,根据密钥生成用户令牌
        String username = "administrator";
        String password = LtpaTokenManager.generate(username, configPath).toString();
        System.out.println("password: " + password);

        //生成EAS单点登录地址 192.168.0.119 192.168.2.219
        String url = "http://192.168.2.219:6888/portal/index2sso.jsp?username=" + username + "&password=" + password + "&redirectTo=" + redirectTo + "&isNotCheckRelogin=true";
        //验证Token
        LtpaTokenManager.isValid(password);
        System.out.println(url);
        return url;
    }


}
