package com.shr.serivce.impl;

import com.kingdee.shr.api.Response;
import com.shr.api.CallShrOsfApi;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IEmployeeService;
import com.shr.transfer.employee.*;
import com.shr.utils.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class EmployeeServiceImpl implements IEmployeeService {

    @Autowired
    private CallShrOsfApi callShrOsfApi;


    @Override
    public EmployeeListOutVo employeeList(EmployeeListInVo inVo) {
        Response response = callShrOsfApi.callShrOsf("inteOAGetPersonDataService", null);

        EmployeeListOutVo outVo = new EmployeeListOutVo();
        outVo.setRecords(JsonUtil.toList(JsonUtil.toString(response.getData()), Object.class));
        return outVo;
    }

    @Override
    public EmployeeEmploymentListOutVo employeeEmploymentList(EmployeeEmploymentListInVo inVo) {
        Response response = callShrOsfApi.callShrOsf("inteOAGetEmpOrgRelationService", null);

        EmployeeEmploymentListOutVo outVo = new EmployeeEmploymentListOutVo();
        outVo.setRecords(JsonUtil.toList(JsonUtil.toString(response.getData()), Object.class));
        return outVo;
    }

    @Override
    public RestResponse employeeInduction(EmployeeInductionInVo employeeInductionInVo) {
        Map<String, Object> map = new HashMap<>();
        map.put("person_name", employeeInductionInVo.getPersonName());
        map.put("person_number", employeeInductionInVo.getPersonNumber());
        map.put("person_passportNO", employeeInductionInVo.getPersonPassportNo());
        map.put("posNumber", employeeInductionInVo.getPosNumber());
        map.put("person_employeeType", employeeInductionInVo.getPersonEmployeeType());
        map.put("person_effdt", employeeInductionInVo.getPersonEffdt());

        callShrOsfApi.callShrOsf("synPersonToSHRService", map);
        return RestResponse.success();
    }

    @Override
    public RestResponse employeeTransfer(EmployeeTransferInVo employeeTransferInVo) {
        Map<String, Object> map = new HashMap<>();
        map.put("person_name", employeeTransferInVo.getPersonName());
        map.put("person_number", employeeTransferInVo.getPersonNumber());
        map.put("posNumber", employeeTransferInVo.getPosNumber());
        map.put("person_passportNO", employeeTransferInVo.getPersonPassportNo());
        map.put("person_employeeType", employeeTransferInVo.getPersonEmployeeType());
        map.put("bizDefineNumber", employeeTransferInVo.getBizDefineNumber());
        map.put("person_effdt", employeeTransferInVo.getPersonEffdt());
        map.put("actionReasonNumber", employeeTransferInVo.getActionReasonNumber());

        callShrOsfApi.callShrOsf("synPersonToSHRService", map);
        return RestResponse.success();
    }

    @Override
    public RestResponse employeeTurnover(EmployeeTurnoverInVo employeeTurnoverInVo) {
        Map<String, Object> map = new HashMap<>();
        map.put("posNumber", employeeTurnoverInVo.getPosNumber());
        map.put("person_name", employeeTurnoverInVo.getPersonName());
        map.put("person_number", employeeTurnoverInVo.getPersonNumber());
        map.put("person_passportNO", employeeTurnoverInVo.getPersonPassportNo());
        map.put("person_employeeType", employeeTurnoverInVo.getPersonEmployeeType());
        map.put("person_effdt", employeeTurnoverInVo.getPersonEffdt());
        map.put("bizDefineNumber", employeeTurnoverInVo.getBizDefineNumber());
        map.put("actionReasonNumber", employeeTurnoverInVo.getActionReasonNumber());

        callShrOsfApi.callShrOsf("synPersonToSHRService", map);
        return RestResponse.success();
    }


}
