package com.shr.controller;

import com.shr.annotion.AccessLog;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IEmployeeService;
import com.shr.transfer.employee.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class EmployeeController {

    @Autowired
    private IEmployeeService employeeService;


    @AccessLog("员工列表")
    @GetMapping("/employee/list")
    public RestResponse employeeList(@ModelAttribute @Validated EmployeeListInVo inVo) {
        EmployeeListOutVo outVo = employeeService.employeeList(inVo);
        return RestResponse.success(outVo);
    }

    @AccessLog("员工任职列表")
    @PostMapping("/employee/employment/list")
    public RestResponse employeeEmploymentList(@RequestBody(required = true) @Validated EmployeeEmploymentListInVo inVo) {
        EmployeeEmploymentListOutVo outVo = employeeService.employeeEmploymentList(inVo);
        return RestResponse.success(outVo);
    }

    @AccessLog("员工入职")
    @PostMapping("/employee/induction")
    public RestResponse employeeInduction(@RequestBody(required = true) @Validated EmployeeInductionInVo inVo) {
        return employeeService.employeeInduction(inVo);
    }

    @AccessLog("员工调动")
    @PostMapping("/employee/transfer")
    public RestResponse employeeTransfer(@RequestBody(required = true) @Validated EmployeeTransferInVo inVo) {
        return employeeService.employeeTransfer(inVo);
    }

    @AccessLog("员工离职")
    @PostMapping("/employee/turnover")
    public RestResponse employeeTurnover(@RequestBody(required = true) @Validated EmployeeTurnoverInVo inVo) {
        return employeeService.employeeTurnover(inVo);
    }


}
