/*
 * Decompiled with CFR 0.152.
 */
package com.eetrust.security.crypto;

import com.eetrust.security.crypto.EncoderException;
import com.eetrust.security.crypto.TripleDES;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Secure3DES {
    private String plainText;
    private String cipherText;

    public boolean encrypt(String plainText, String secretKey, String iv) throws EncoderException {
        try {
            TripleDES des = new TripleDES();
            byte[] encrypted = des.encrypt(plainText.getBytes("GBK"), secretKey.getBytes(), iv.getBytes());
            this.cipherText = new BASE64Encoder().encode(encrypted);
            if (this.cipherText != null && this.cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(this.cipherText);
                this.cipherText = m.replaceAll("");
            }
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        return true;
    }

    public boolean decrypt(String cipherText, String secretKey, String iv) throws EncoderException {
        try {
            byte[] data = new BASE64Decoder().decodeBuffer(cipherText);
            TripleDES des = new TripleDES();
            byte[] decrypted = des.decrypt(data, secretKey.getBytes(), iv.getBytes());
            this.plainText = new String(decrypted, "GBK");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
            throw new EncoderException(e.getMessage());
        }
        return true;
    }

    public String getPlainText() {
        return this.plainText;
    }

    public String getCipherText() {
        return this.cipherText;
    }
}

