package com.shr.controller;

import com.shr.common.response.RestResponse;
import com.shr.serivce.IUnProcessAssign;
import com.shr.transfer.unprocessassign.UnProcessAssignDetailedInVo;
import com.shr.transfer.unprocessassign.UnProcessAssignDetailedOutVo;
import com.shr.transfer.unprocessassign.UnProcessAssignListInVo;
import com.shr.transfer.unprocessassign.UnProcessAssignListOutVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class UnProcessAssignController {

    @Autowired
    private IUnProcessAssign unProcessAssign;


    @PostMapping("/un/process/assign/list")
    public RestResponse unProcessAssignList(@RequestBody(required = true) @Validated UnProcessAssignListInVo inVo) {
        UnProcessAssignListOutVo outVo = unProcessAssign.unProcessAssignList(inVo);
        return RestResponse.success(outVo);
    }

    @PostMapping("/un/process/assign/detailed")
    public RestResponse unProcessAssignDetailed(@RequestBody(required = true) @Validated UnProcessAssignDetailedInVo inVo) {
        UnProcessAssignDetailedOutVo outVo = unProcessAssign.unProcessAssignDetailed(inVo);
        return RestResponse.success(outVo);
    }


}
