/*
 * Decompiled with CFR 0.152.
 */
package org.eetrust.security.client.validation;

import com.eetrust.security.crypto.EncoderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eetrust.security.client.authentication.AttributePrincipalImpl;
import org.eetrust.security.client.util.CommonUtils;
import org.eetrust.security.client.validation.Assertion;
import org.eetrust.security.client.validation.AssertionImpl;
import org.eetrust.security.client.validation.MessageRequest;
import org.eetrust.security.client.validation.RequestException;
import org.eetrust.security.client.validation.TicketValidationException;
import org.eetrust.security.client.validation.TicketValidator;
import sun.misc.BASE64Decoder;

public class MessageTicketValidator
implements TicketValidator {
    private String serverValidationHost;
    private int serverValidationPort;
    private String communicationServerName;
    private String communicationProtocol;
    private String communicationCharset;
    private String resourceCode;
    private boolean queryAuthorizedApps;
    private static final String VERIFY_TYPE_TICKET = "ticket";
    public static final int SECURITY_SERVICE_SUCCESS = 0;

    @Override
    public Assertion validate(String ticket) throws TicketValidationException {
        if (CommonUtils.isEmpty(this.resourceCode) || CommonUtils.isEmpty(ticket)) {
            throw new TicketValidationException("Invalid Ticket!");
        }
        if (ticket.startsWith("DT-")) {
            try {
                ticket = ticket.substring(3);
                ticket = new String(new BASE64Decoder().decodeBuffer(ticket));
                String serverInfo = ticket.substring(0, ticket.indexOf("|"));
                StringTokenizer strToken = new StringTokenizer(serverInfo, ":");
                String[] params = new String[strToken.countTokens()];
                int i = 0;
                while (i < params.length) {
                    params[i] = strToken.nextToken();
                    ++i;
                }
                if (params != null && (params.length == 3 || params.length == 4)) {
                    if (!CommonUtils.isEmpty(params[0]) && !this.communicationProtocol.equals(params[0])) {
                        this.communicationProtocol = params[0];
                    }
                    if (!CommonUtils.isEmpty(params[1]) && !this.serverValidationHost.equals(params[1])) {
                        this.serverValidationHost = params[1];
                    }
                    int n = this.serverValidationPort = !CommonUtils.isEmpty(params[2]) ? Integer.parseInt(params[2]) : 80;
                    if (params.length == 4 && !CommonUtils.isEmpty(params[3]) && !this.communicationServerName.equals(params[3])) {
                        this.communicationServerName = params[3];
                    }
                }
                ticket = ticket.substring(ticket.indexOf("|") + 1);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new TicketValidationException("TICKET FORMAT ERROR!");
            }
        }
        StringBuffer reqMessage = new StringBuffer();
        reqMessage.append("<?xml version='1.0' encoding='UTF-8'?>");
        reqMessage.append("<sid-verify>");
        reqMessage.append("<licenseKey>" + this.resourceCode + "</licenseKey>");
        reqMessage.append("<verify-type>ticket</verify-type>");
        reqMessage.append("<verify-queryAuthorizedApps>" + (this.queryAuthorizedApps ? "0" : "1") + "</verify-queryAuthorizedApps>");
        reqMessage.append("<verify-ticket>");
        reqMessage.append("<ticket>" + ticket + "</ticket>");
        reqMessage.append("</verify-ticket>");
        reqMessage.append("</sid-verify>");
        try {
            MessageRequest messageRequest = new MessageRequest(this.serverValidationHost, this.serverValidationPort, this.communicationServerName, this.communicationProtocol, this.communicationCharset);
            String respMessage = messageRequest.sendMessage(reqMessage.toString());
            if (CommonUtils.isEmpty(respMessage)) {
                throw new TicketValidationException("Response Message IS NULL!");
            }
            Document document = DocumentHelper.parseText((String)respMessage);
            Element root = document.getRootElement();
            String resResult = root.elementTextTrim("result");
            if (resResult == null) {
                throw new TicketValidationException("Unable TO Parse Response Message!");
            }
            if (Integer.parseInt(resResult) == 0) {
                String passport = root.elementTextTrim("passport");
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                Element userDataElement = root.element("userData");
                if (userDataElement != null) {
                    Iterator it = userDataElement.elementIterator();
                    while (it.hasNext()) {
                        Element e = (Element)it.next();
                        attributes.put(e.getName(), e.getText());
                    }
                }
                String userAuthorizedApps = root.elementTextTrim("userAuthorizedApps");
                if (this.queryAuthorizedApps && !CommonUtils.isEmpty(userAuthorizedApps)) {
                    ArrayList<String> appList = new ArrayList<String>();
                    StringTokenizer commaToker = new StringTokenizer(userAuthorizedApps, "|");
                    String[] params = new String[commaToker.countTokens()];
                    int i = 0;
                    while (i < params.length) {
                        params[i] = commaToker.nextToken();
                        if (!CommonUtils.isEmpty(params[i])) {
                            // empty if block
                        }
                        appList.add(params[i]);
                        ++i;
                    }
                    attributes.put("userAuthorizedApps", appList);
                }
                AttributePrincipalImpl attributePrincipal = new AttributePrincipalImpl(passport, attributes);
                AssertionImpl assertion = new AssertionImpl(attributePrincipal);
                return assertion;
            }
            String respErrorMsg = root.elementTextTrim("errorMsg");
            throw new TicketValidationException(respErrorMsg);
        }
        catch (EncoderException e) {
            e.printStackTrace();
            throw new TicketValidationException("Encoder Data Fail.");
        }
        catch (RequestException e) {
            e.printStackTrace();
            throw new TicketValidationException("Connection authentication server Fail.");
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new TicketValidationException("Unable TO Parse Response Message!");
        }
    }

    public void setServerValidationHost(String serverValidationHost) {
        this.serverValidationHost = serverValidationHost;
    }

    public void setServerValidationPort(int serverValidationPort) {
        this.serverValidationPort = serverValidationPort;
    }

    public void setCommunicationServerName(String communicationServerName) {
        this.communicationServerName = communicationServerName;
    }

    public void setCommunicationProtocol(String communicationProtocol) {
        this.communicationProtocol = communicationProtocol;
    }

    public void setCommunicationCharset(String communicationCharset) {
        this.communicationCharset = communicationCharset;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public void setQueryAuthorizedApps(boolean queryAuthorizedApps) {
        this.queryAuthorizedApps = queryAuthorizedApps;
    }
}

