/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.api;

import com.kingdee.shr.api.Response;
import com.kingdee.shr.api.Token;
import com.kingdee.shr.sso.client.ltpa.LtpaTokenManager;
import com.kingdee.shr.sso.client.util.SSOUtil;
import com.kingdee.shr.sso.client.util.UrlUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SHRClient {
    private static final String ALLOW_CIRCULAR_REDIRECTS = "http.protocol.allow-circular-redirects";
    private static final String JSESSIONID_KEY = "JSESSIONID";
    private static final String SERVICE_PATH = "/shr/msf/service.do";
    private static final String SERVICE_NAME = "serviceName";
    private static final String METHOD = "method";
    private static final String SHR_SSO_TOKEN = "_shr_sso_token";

    public Token login(HttpServletRequest request) throws HttpException, IOException {
        return this.login(request, null);
    }

    public Token login(HttpServletRequest request, String serverUrl) throws HttpException, IOException {
        String url = SSOUtil.generateUrl(request, serverUrl);
        return this.loginShr(request, url);
    }

    public Token loginByUser(HttpServletRequest request) throws HttpException, IOException {
        return this.loginByUser(request, null);
    }

    public Token loginByUser(HttpServletRequest request, String serverUrl) throws HttpException, IOException {
        String loginUrl = SSOUtil.getLoginUrl(request, serverUrl);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", "user");
        SSOUtil.assembleLoginParameters(request, parameters);
        String url = UrlUtil.assembleUrl(loginUrl, parameters);
        return this.loginShr(request, url);
    }

    public Response executeService(String serverUrl, String serviceName, Map<String, Object> param) throws HttpException, IOException {
        Token token = this.loginShrByUser(serverUrl);
        return this.executeOSFService(serverUrl, token, serviceName, param);
    }

    public Response executeOSFService(String serverUrl, Token token, String serviceName, Map<String, Object> param) throws HttpException, IOException {
        String loginUrl = String.valueOf(serverUrl) + SERVICE_PATH;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(METHOD, "callService");
        parameters.put(SERVICE_NAME, serviceName);
        if (param != null && param.size() > 0) {
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                if ("recordList".equals(entry.getKey().toString())) continue;
                parameters.put(entry.getKey(), entry.getValue());
            }
        }
        String url = UrlUtil.assembleUrl(loginUrl, parameters);
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        if (param != null && param.size() > 0) {
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                if (!"recordList".equals(entry.getKey().toString())) continue;
                method.setParameter(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        this.addToken(client, token);
        method.addRequestHeader("Referer", serverUrl);
        int status = client.executeMethod((HttpMethod)method);
        Response response = new Response();
        if (status != 200) {
            System.err.println("Method failed: " + method.getStatusLine());
            System.err.println("response: " + method.getResponseBodyAsString());
            throw new HttpException("status: " + status + ", request url: " + url + " failed");
        }
        String content = method.getResponseBodyAsString();
        response.setData(content);
        method.releaseConnection();
        return response;
    }

    public Token loginShrByUser(String serverUrl) throws IOException, HttpException {
        String loginUrl = String.valueOf(serverUrl) + "/OTP2sso.jsp";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", "user");
        String password = LtpaTokenManager.generate((String)parameters.get("username"), LtpaTokenManager.getDefaultLtpaConfig(), "OTP").toString();
        parameters.put("password", password);
        parameters.put("userAuthPattern", "OTP");
        parameters.put("isNotCheckRelogin", "true");
        String url = UrlUtil.assembleUrl(loginUrl, parameters);
        HttpClient client = new HttpClient();
        client.getParams().setParameter(ALLOW_CIRCULAR_REDIRECTS, (Object)true);
        GetMethod method = new GetMethod(url);
        method.addRequestHeader("Referer", serverUrl);
        method.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
        method.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        method.setFollowRedirects(true);
        int status = client.executeMethod((HttpMethod)method);
        Token token = null;
        if (status != 200) {
            System.err.println("Method failed: " + method.getStatusLine());
            throw new HttpException("login shr fail, status: " + status);
        }
        token = this.getToken(client.getState().getCookies());
        return token;
    }

    private Token loginShr(HttpServletRequest request, String loginUrl) throws IOException, HttpException {
        HttpClient client = new HttpClient();
        client.getParams().setParameter(ALLOW_CIRCULAR_REDIRECTS, (Object)true);
        GetMethod method = new GetMethod(loginUrl);
        method.addRequestHeader("Referer", loginUrl);
        int status = client.executeMethod((HttpMethod)method);
        Token token = null;
        if (status != 200) {
            System.err.println("Method failed: " + method.getStatusLine());
            throw new HttpException("login shr fail, status: " + status);
        }
        token = this.getToken(client.getState().getCookies());
        method.releaseConnection();
        request.getSession().setAttribute(SHR_SSO_TOKEN, (Object)token);
        return token;
    }

    private Token getToken(Cookie[] cookies) throws HttpException {
        Cookie cookie = null;
        int i = 0;
        while (i < cookies.length) {
            cookie = cookies[i];
            if (JSESSIONID_KEY.equalsIgnoreCase(cookie.getName()) && cookie.getPath().indexOf("sso") == -1) {
                Token token = new Token();
                token.setDomain(cookie.getDomain());
                token.setPath(cookie.getPath());
                token.setValue(cookie.getValue());
                return token;
            }
            ++i;
        }
        throw new HttpException("getToken fail, cookies: " + this.cookieToString(cookies));
    }

    private String cookieToString(Cookie[] cookies) {
        Cookie cookie = null;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < cookies.length) {
            cookie = cookies[i];
            if (i != 0) {
                sb.append(",");
            }
            sb.append("[name=");
            sb.append(cookie.getName());
            sb.append(", path=");
            sb.append(cookie.getPath());
            sb.append(", value=");
            sb.append(cookie.getValue());
            sb.append("]");
            ++i;
        }
        return sb.toString();
    }

    public Response execute(HttpServletRequest request, String serverUrl, String serviceName, Map<String, Object> parameters) throws IOException {
        if (serverUrl == null || serverUrl.length() == 0) {
            throw new HttpException("serverUrl is null");
        }
        if (serviceName == null) {
            throw new HttpException("serviceName is null");
        }
        Token token = (Token)request.getSession().getAttribute(SHR_SSO_TOKEN);
        if (token == null) {
            token = this.login(request);
        }
        HttpClient client = new HttpClient();
        this.addToken(client, token);
        client.getParams().setParameter(ALLOW_CIRCULAR_REDIRECTS, (Object)true);
        String url = this.generateRequestUrl(serverUrl, serviceName, parameters);
        PostMethod method = new PostMethod(url);
        method.addRequestHeader("Referer", serverUrl);
        int status = client.executeMethod((HttpMethod)method);
        Response response = new Response();
        if (status != 200) {
            System.err.println("Method failed: " + method.getStatusLine());
            throw new HttpException("status: " + status + ", request url: " + url + " failed");
        }
        String content = method.getResponseBodyAsString();
        response.setData(content);
        method.releaseConnection();
        return response;
    }

    public Response execute(HttpServletRequest request, String serviceName, Map<String, Object> parameters) throws IOException {
        String serverUrl = SSOUtil.getServerUrl(request);
        return this.execute(request, serverUrl, serviceName, parameters);
    }

    private void addToken(HttpClient client, Token token) {
        Cookie cookie = new Cookie();
        cookie.setName(JSESSIONID_KEY);
        cookie.setDomain(token.getDomain());
        cookie.setPath(token.getPath());
        cookie.setValue(token.getValue());
        client.getState().addCookie(cookie);
    }

    private String generateRequestUrl(String serverUrl, String serviceName, Map<String, Object> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        parameters.put(SERVICE_NAME, serviceName);
        parameters.put(METHOD, "callService");
        String url = String.valueOf(serverUrl) + SERVICE_PATH;
        return UrlUtil.assembleUrl(url, parameters);
    }

    public static void main(String[] args) throws HttpException, IOException {
        SHRClient client = new SHRClient();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billId", "dghEiOF+TUW4h5Wr9gVQKaDzlng=");
        param.put("auditFlag", "auditpass");
        client.executeService("http://localhost:6888/shr", "auditLeave_new", param);
    }
}

