package com.shr.controller;

import com.shr.annotion.AccessLog;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IAdminOrgService;
import com.shr.serivce.IToDoTaskService;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.jsp.jstl.sql.Result;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.shr.utils.*;

import cn.hutool.core.lang.Console;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class ToDoTaskController {

	@Autowired
	DataSourceProperties dataSource;
    @Autowired
    private IToDoTaskService toDoTaskService;

	
    @AccessLog("待办任务列表总数")
    @GetMapping("/assign")
    public RestResponse toDoTaskList() {
    	DBHelper dbHelper = new DBHelper(dataSource);
    	Result result = dbHelper.executeQuery("select T0.FASSIGNID, T0.FSUBJECT_L1 || ' ' || T0.FPRIORPERFORMERNAME_L1 || '的' || T0.FPROCDEFNAME_L1 FSUBJECT_L1,  T0.FCreatedTime, T1.FNUMBER FUserNumber, T2.FNUMBER FUserNumber2 from t_wfr_assign_view T0 inner join t_pm_user T1 on T0.FPERSONUSERID = T1.FID inner join t_pm_user T2 on T0.FPRIORPERFORMER = T2.FID where T0.FPERSONUSERID = 'm8flj0z/S1+EVpjQbDXnpxO33n8='");
    	toDoTaskService.toDoTaskList(result);
    	
        return RestResponse.success("同步成功");
    }

    @AccessLog("待办任务明细列表")
    @GetMapping("/assigndetial")
    public RestResponse toDoTaskDetailList() {
    	DBHelper dbHelper = new DBHelper(dataSource);
    	Result result = dbHelper.executeQuery("select FASSIGNID ID from t_wfr_assign_view");
    	toDoTaskService.toDoTaskDetailList(result);
        return RestResponse.success("同步成功");
    }
}
