/*
 * Decompiled with CFR 0.152.
 */
package org.eetrust.security.client.validation;

import javax.servlet.FilterConfig;
import org.eetrust.security.client.util.CommonUtils;
import org.eetrust.security.client.validation.AbstractTicketValidationFilter;
import org.eetrust.security.client.validation.MessageTicketValidator;
import org.eetrust.security.client.validation.TicketValidator;

public class MessageTicketValidationFilter
extends AbstractTicketValidationFilter {
    @Override
    protected final TicketValidator getTicketValidator(FilterConfig filterConfig) {
        String serverValidationHost = this.getPropertyFromInitParams(filterConfig, "serverValidationHost", null);
        CommonUtils.assertNotNull(serverValidationHost, "serverValidationHost cannot be null.");
        int serverValidationPort = this.parseInteger(this.getPropertyFromInitParams(filterConfig, "serverValidationPort", "80"));
        CommonUtils.assertNotNull(serverValidationPort, "serverValidationPort cannot be null.");
        String communicationServerName = this.getPropertyFromInitParams(filterConfig, "communicationServerName", null);
        String communicationProtocol = this.getPropertyFromInitParams(filterConfig, "communicationProtocol", "http");
        String communicationCharset = this.getPropertyFromInitParams(filterConfig, "communicationCharset", "GBK");
        boolean queryAuthorizedApps = this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "queryAuthorizedApps", "false"));
        MessageTicketValidator validator = new MessageTicketValidator();
        validator.setServerValidationHost(serverValidationHost);
        validator.setServerValidationPort(serverValidationPort);
        validator.setCommunicationServerName(communicationServerName);
        validator.setCommunicationProtocol(communicationProtocol);
        validator.setCommunicationCharset(communicationCharset);
        validator.setResourceCode(this.getResourceCode());
        validator.setQueryAuthorizedApps(queryAuthorizedApps);
        return validator;
    }
}

