package com.shr.dao;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.shr.model.Log;
import com.shr.transfer.log.LogListInVo;
import com.shr.transfer.log.LogListOutVoRecords;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface LogMapper extends BaseMapper<Log> {

    /**
     * 日志列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<LogListOutVoRecords> logList(@Param("page") Page<LogListOutVoRecords> page, @Param("inVo") LogListInVo inVo);

    /**
     * 是否存在表
     *
     * @return 0-不存在 1-已存在
     */
    Integer isTable();

    /**
     * 创建日志表
     */
    void createTable();


}
