package com.shr.serivce.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.shr.dao.LogMapper;
import com.shr.serivce.ILogService;
import com.shr.transfer.log.LogListInVo;
import com.shr.transfer.log.LogListOutVo;
import com.shr.transfer.log.LogListOutVoRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.List;

/**
 * @author Inori
 */
@Service
public class LogServiceImpl implements ILogService {

    @Autowired
    private LogMapper logMapper;


    @PostConstruct
    public void init() {
        Integer isTable = logMapper.isTable();
        System.out.println(isTable);
        if (isTable == 0) {
            logMapper.createTable();
        }
    }

    @Override
    public LogListOutVo logList(LogListInVo inVo) {
        Page<LogListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<LogListOutVoRecords> recordsList = logMapper.logList(page, inVo);

        LogListOutVo outVo = new LogListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }


}
