package com.shr.controller;

import com.shr.annotion.AccessLog;
import com.shr.common.response.RestResponse;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.shr.utils.*;

import cn.hutool.core.lang.Console;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class ToDoTaskController {

	@Autowired
	DataSourceProperties dataSource;
	
    @AccessLog("待办任务列表总数")
    @GetMapping("/assign")
    public RestResponse toDoTaskList() {
    	DBHelper dbHelper = DBHelper.createDBHelper(dataSource);
    	ResultSet result = dbHelper.executeQuery("select * from t_wfr_assign_view", null);
    	
        return RestResponse.success(resultToJson(result));
    }
    

	private String resultToJson(ResultSet rs)
	{        
		String result = "";
		try {
			Console.log("beginPraseJson");
			while(rs.next()){
				Console.log("PrasingJson");
				//Retrieve by column name
				String courseid  = rs.getString("FSUBJECT_L1");
				String name = rs.getString("FSUBJECT_L2");
				String prerequisites = rs.getString("FSUBJECT_L3");
	
				result += "<tr><td>"+courseid+"</td><td>"+name+"</td><td>"+prerequisites + "</td></tr>";
				Console.log(result);
			}
			Console.log("endPraseJson");
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
	}

    @AccessLog("待办任务明细列表")
    @GetMapping("/assigndetial")
    public RestResponse toDoTaskDetailList() {
    	DBHelper dbHelper = DBHelper.createDBHelper(dataSource);
    	ResultSet result = dbHelper.executeQuery("select * from t_wfr_assigndetial_view", null);
        return RestResponse.success(resultToJson(result));
    }


}
