package com.shr.controller;

import com.shr.annotion.AccessLog;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IToDoTaskService;
import com.shr.transfer.task.ToDoTaskDetailListInVo;
import com.shr.transfer.task.ToDoTaskDetailListOutVo;
import com.shr.transfer.task.ToDoTaskListInVo;
import com.shr.transfer.task.ToDoTaskListOutVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class ToDoTaskController {

    @Autowired
    private IToDoTaskService toDoTaskService;


    @AccessLog("待办任务列表总数")
    @GetMapping("/to/do/task/list")
    public RestResponse toDoTaskList(@ModelAttribute @Validated ToDoTaskListInVo inVo) {
        ToDoTaskListOutVo outVo = toDoTaskService.toDoTaskList(inVo);
        return RestResponse.success(outVo);
    }

    @AccessLog("待办任务明细列表")
    @GetMapping("/to/do/task/detail/list")
    public RestResponse toDoTaskDetailList(@ModelAttribute @Validated ToDoTaskDetailListInVo inVo) {
        ToDoTaskDetailListOutVo outVo = toDoTaskService.toDoTaskDetailList(inVo);
        return RestResponse.success(outVo);
    }


}
