package com.shr.log.factory;


import com.shr.common.SpringContextHolder;
import com.shr.dao.LogMapper;
import com.shr.model.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.TimerTask;

/**
 * 日志操作任务创建工厂
 *
 * @author Inori
 */
public class LogTaskFactory {

    private static Logger logger = LoggerFactory.getLogger(LogTaskFactory.class);

    private static LogMapper logMapper = SpringContextHolder.getBean(LogMapper.class);


    public static TimerTask log(final String content, final String systemType, final String result) {
        return new TimerTask() {
            @Override
            public void run() {
                Log sysLog = LogFactory.createOperationLog(content, systemType, result);
                try {
                    logMapper.insert(sysLog);
                } catch (Exception e) {
                    logger.error("日志创建失败!", e);
                }
            }
        };
    }


}
