package com.shr.controller;

import com.shr.annotion.AccessLog;
import com.shr.common.response.RestResponse;

import java.sql.ResultSet;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.shr.utils.*;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class ToDoTaskController {

	@Autowired
	DataSource dataSource;
	
    @AccessLog("待办任务列表总数")
    @GetMapping("/assign")
    public RestResponse toDoTaskList() {
    	DBHelper dbHelper = DBHelper.createDBHelper(dataSource);
    	ResultSet result = dbHelper.executeQuery("select * from t_wfr_assign_view", null);
        return RestResponse.success(result);
    }

    @AccessLog("待办任务明细列表")
    @GetMapping("/assigndetial")
    public RestResponse toDoTaskDetailList() {
    	DBHelper dbHelper = DBHelper.createDBHelper(dataSource);
    	ResultSet result = dbHelper.executeQuery("select * from t_wfr_assigndetial_view", null);
        return RestResponse.success(result);
    }


}
