package com.shr.utils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * @author Inori
 */
public class CommonUtils {
    private static final String BUNDLE_NAME = "com.eetrust.security.sso.config";

    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

    private CommonUtils() {
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        } catch (MissingResourceException e) {
            return null;
        }
    }

    /**
     * 判断字符串是否未空
     */
    public static boolean isEmpty(String input) {
        return input == null || input.trim().length() <= 0;
    }

    /**
     * 返回信息
     */
    public static void responseJsonMsg(HttpServletResponse response, String msg) {
        try {
            response.setHeader("Cache-Control", "no-store, max-age=0, no-cache, must-revalidate");
            response.addHeader("Cache-Control", "post-check=0, pre-check=0");
            response.setHeader("Pragma", "no-cache");
            response.setContentType("text/plain;charset=UTF-8");
            response.getWriter().write(msg);
            response.flushBuffer();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * * Check that the given CharSequence is neither <code>null</code> nor of
     * length 0. * Note: Will return <code>true</code> for a CharSequence that
     * purely consists of whitespace. *
     * <p>
     *
     * <pre>
     *      * StringUtils.hasLength(null) = false     * StringUtils.hasLength(&quot;&quot;) = false     * StringUtils.hasLength(&quot; &quot;) = true     * StringUtils.hasLength(&quot;Hello&quot;) = true     *
     * </pre> *
     *
     * @param str the CharSequence to check (may be <code>null</code>) *
     * @return <code>true</code> if the CharSequence is not null and has
     * length *
     * @see #hasText(String)
     */
    public static boolean hasLength(CharSequence str) {
        return (str != null && str.length() > 0);
    }

    /**
     * * Check whether the given CharSequence has actual text. * More
     * specifically, returns <code>true</code> if the string not
     * <code>null</code>, * its length is greater than 0, and it contains at
     * least one non-whitespace character. *
     * <p>
     *
     * <pre>
     *      * StringUtils.hasText(null) = false     * StringUtils.hasText(&quot;&quot;) = false     * StringUtils.hasText(&quot; &quot;) = false     * StringUtils.hasText(&quot;12345&quot;) = true     * StringUtils.hasText(&quot; 12345 &quot;) = true     *
     * </pre> *
     *
     * @param str the CharSequence to check (may be <code>null</code>) *
     * @return <code>true</code> if the CharSequence is not <code>null</code>, *
     * its length is greater than 0, and it does not contain whitespace
     * only *
     * @see Character#isWhitespace
     */
    public static boolean hasText(CharSequence str) {
        if (!hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; i++) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return true;
            }
        }
        return false;
    }

    /**
     * * Check whether the given String has actual text. * More specifically,
     * returns <code>true</code> if the string not <code>null</code>, * its
     * length is greater than 0, and it contains at least one non-whitespace
     * character. *
     *
     * @param str the String to check (may be <code>null</code>) *
     * @return <code>true</code> if the String is not <code>null</code>,
     * its length is * greater than 0, and it does not contain
     * whitespace only *
     * @see #hasText(CharSequence)
     */
    public static boolean hasText(String str) {
        return hasText((CharSequence) str);
    }

    /**
     * * Count the occurrences of the substring in string s. *
     *
     * @param str string to search in. Return 0 if this is null. *
     * @param sub string to search for. Return 0 if this is null.
     */
    public static int countOccurrencesOf(String str, String sub) {
        if (str == null || sub == null || str.length() == 0
                || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        int idx;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    /**
     * * Tokenize the given String into a String array via a StringTokenizer. *
     * Trims tokens and omits empty tokens. *
     * <p>
     * The given delimiters string is supposed to consist of any number of *
     * delimiter characters. Each of those characters can be used to separate *
     * tokens. A delimiter is always a single character; for multi-character *
     * delimiters, consider using <code>delimitedListToStringArray</code> *
     *
     * @param str        the String to tokenize *
     * @param delimiters the delimiter characters, assembled as String * (each of those
     *                   characters is individually considered as delimiter). *
     * @return an array of the tokens *
     * @see StringTokenizer *
     * @see String#trim() *
     */
    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return tokenizeToStringArray(str, delimiters, true, true);
    }

    /**
     * * Tokenize the given String into a String array via a StringTokenizer. *
     * <p>
     * The given delimiters string is supposed to consist of any number of *
     * delimiter characters. Each of those characters can be used to separate *
     * tokens. A delimiter is always a single character; for multi-character *
     * delimiters, consider using <code>delimitedListToStringArray</code> *
     *
     * @param str               the String to tokenize *
     * @param delimiters        the delimiter characters, assembled as String * (each of those
     *                          characters is individually considered as delimiter) *
     * @param trimTokens        trim the tokens via String's <code>trim</code> *
     * @param ignoreEmptyTokens omit empty tokens from the result array * (only applies to
     *                          tokens that are empty after trimming; StringTokenizer * will
     *                          not consider subsequent delimiters as token in the first
     *                          place). *
     * @return an array of the tokens (<code>null</code> if the input String *
     * was <code>null</code>) *
     * @see StringTokenizer *
     * @see String#trim() *
     * @see #delimitedListToStringArray
     */
    public static String[] tokenizeToStringArray(String str, String delimiters,
                                                 boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        List<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (!ignoreEmptyTokens || token.length() > 0) {
                tokens.add(token);
            }
        }
        return toStringArray(tokens);
    }

    /**
     * * Copy the given Collection into a String array. * The Collection must
     * contain String elements only. *
     *
     * @param collection the Collection to copy *
     * @return the String array (<code>null</code> if the passed-in *
     * Collection was <code>null</code>)
     */
    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }
}
