package com.shr.serivce.impl;

import com.kingdee.shr.api.Response;
import com.shr.api.CallShrOsfApi;
import com.shr.serivce.IUnProcessAssign;
import com.shr.transfer.unprocessassign.UnProcessAssignDetailedInVo;
import com.shr.transfer.unprocessassign.UnProcessAssignDetailedOutVo;
import com.shr.transfer.unprocessassign.UnProcessAssignListInVo;
import com.shr.transfer.unprocessassign.UnProcessAssignListOutVo;
import com.shr.utils.JsonUtil;
import com.shr.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class UnProcessAssignImpl implements IUnProcessAssign {

    @Autowired
    private CallShrOsfApi callShrOsfApi;


    @Override
    public UnProcessAssignListOutVo unProcessAssignList(UnProcessAssignListInVo inVo) {
        Response response = callShrOsfApi.callShrOsf("getUnProcessAssignCount", null);

        UnProcessAssignListOutVo outVo = new UnProcessAssignListOutVo();
        outVo.setRecords(JsonUtil.toList(JsonUtil.toString(response.getData()), Object.class));
        return outVo;
    }

    @Override
    public UnProcessAssignDetailedOutVo unProcessAssignDetailed(UnProcessAssignDetailedInVo inVo) {
        Map<String, Object> map = new HashMap<>(3);
        if (StringUtil.isNotBlank(inVo.getTotal())) {
            map.put("total", inVo.getTotal());
        }
        if (StringUtil.isNotBlank(inVo.getPage())) {
            map.put("page", inVo.getPage());
        }
        if (StringUtil.isNotBlank(inVo.getRows())) {
            map.put("rows", inVo.getRows());
        }
        Response response = callShrOsfApi.callShrOsf("getUnProcessAssignCount", map);

        UnProcessAssignDetailedOutVo outVo = new UnProcessAssignDetailedOutVo();
        outVo.setRecords(JsonUtil.toList(JsonUtil.toString(response.getData()), Object.class));
        return outVo;
    }


}
