package com.shr.serivce.impl;

import com.kingdee.shr.api.Response;
import com.shr.api.CallShrOsfApi;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IAdminOrgService;
import com.shr.transfer.adminorg.AdminOrgInVo;
import com.shr.transfer.adminorg.AdminOrgListInVo;
import com.shr.transfer.adminorg.AdminOrgListOutVo;
import com.shr.utils.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class AdminOrgServiceImpl implements IAdminOrgService {

    @Autowired
    private CallShrOsfApi callShrOsfApi;


    @Override
    public AdminOrgListOutVo adminOrgList(AdminOrgListInVo inVo) {
        Response response = callShrOsfApi.callShrOsf("inteOAGetAdminOrgDataService", null);

        AdminOrgListOutVo outVo = new AdminOrgListOutVo();
        outVo.setRecords(JsonUtil.toList(JsonUtil.toString(response.getData()), Object.class));
        return outVo;
    }

    @Override
    public RestResponse adminOrgAddOrUpdate(AdminOrgInVo inVo) {
        Map<String, Object> map = new HashMap<>(3);
        map.put("org_name", inVo.getOrgName());
        map.put("org_number", inVo.getOrgNumber());
        map.put("parentOrgNumber", inVo.getParentOrgNumber());

        callShrOsfApi.callShrOsf("synAdminOrgToSHRService", map);
        return RestResponse.success();
    }


}
