package com.shr.serivce.impl;

import com.kingdee.shr.api.Response;
import com.shr.api.CallShrOsfApi;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IToDoTaskService;
import com.shr.transfer.task.ToDoTaskDetailListInVo;
import com.shr.transfer.task.ToDoTaskDetailListOutVo;
import com.shr.transfer.task.ToDoTaskListInVo;
import com.shr.transfer.task.ToDoTaskListOutVo;
import com.shr.utils.HttpClientUtil;
import com.shr.utils.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class ToDoTaskServiceImpl implements IToDoTaskService {

    @Autowired
    private CallShrOsfApi callShrOsfApi;


    @Override
    public ToDoTaskListOutVo toDoTaskList(ToDoTaskListInVo inVo) {
        Response totalResponse = callShrOsfApi.callShrOsf("getUnProcessAssignCount", null);
        Map<String, Object> map = JsonUtil.toMap(JsonUtil.toString(totalResponse.getData()), String.class, Object.class);
        Map<String, Object> temp = new HashMap<>();
        temp.put("total", Integer.parseInt((String) map.get("total")));
        temp.put("page", 1);
        temp.put("rows", 9999);
        Response detailResponse = callShrOsfApi.callShrOsf("getUnProcessAssign", temp);

        ToDoTaskListOutVo outVo = new ToDoTaskListOutVo();
        outVo.setTotal(Integer.parseInt((String) map.get("total")));
        outVo.setTotalRecords(JsonUtil.toList(JsonUtil.toString(map.get("categoryCount")), Object.class));
        outVo.setDetailRecords(JsonUtil.toList(JsonUtil.toString(detailResponse.getData()), Object.class));

        this.toDoTaskSynchronization(outVo);
        return outVo;
    }

    @Override
    public ToDoTaskDetailListOutVo toDoTaskDetailList(ToDoTaskDetailListInVo inVo) {
        Response response = callShrOsfApi.callShrOsf("getUnProcessAssign", null);

        ToDoTaskDetailListOutVo outVo = new ToDoTaskDetailListOutVo();
        outVo.setRecords(JsonUtil.toList(JsonUtil.toString(response.getData()), Object.class));
        return outVo;
    }

    public RestResponse toDoTaskSynchronization(ToDoTaskListOutVo outVo) {
        String url = "http://172.16.1.78:81";
        String json = "{\"userName\":\"hrrest\",\"password\":\"hrhdrest123\"}";
        String toekn = HttpClientUtil.sendPost(url + "/seeyon/rest/token", json);
        Map<String, Object> temp = JsonUtil.toMap(toekn, String.class, Object.class);
        if (CollectionUtils.isEmpty(temp) && !temp.containsKey("id")) {
            return RestResponse.fail("OA登陆失败");
        }

        List<Map<String, Object>> tempList = new ArrayList<>();
        for (Object object : outVo.getDetailRecords()) {
            Map<String, Object> map = JsonUtil.toMap(JsonUtil.toString(object), String.class, Object.class);
            Map<String, Object> reqeust = new HashMap<>(15);
            reqeust.put("taskId", map.get("id"));
            reqeust.put("registerCode", "3001");
            reqeust.put("title", map.get("subject"));
            reqeust.put("classify", "erp");
            reqeust.put("contentType", "erp");
            reqeust.put("thirdSenderId", "");
            reqeust.put("senderName", map.get("sender"));
            reqeust.put("thirdReceiverId", "");
            reqeust.put("noneBindingReceiver", map.get("priorPerform"));
            reqeust.put("noneBindingSender", map.get("sender"));
            reqeust.put("creationDate", map.get("createdTime"));
            reqeust.put("state", map.get("state"));
            reqeust.put("subState", "0");
            reqeust.put("content", "");
            reqeust.put("url", "http://ericbing/K3Cloud7.5/html5/index.aspx");
            reqeust.put("h5url", "");
            reqeust.put("appParam", "");
            tempList.add(reqeust);
        }
        String result = HttpClientUtil.sendPost(url + "/seeyon/rest/thirdpartyPending/receive?token=" + temp.get("id"), JsonUtil.toString(tempList));
        System.out.println("---------------->" + result);
        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        if (CollectionUtils.isEmpty(map)) {
            return RestResponse.fail("无返回值");
        }
        if ("false".equals(map.get("success"))) {
            List<Object> errorList = JsonUtil.toList(JsonUtil.toString(map.get("errorMsgs")), Object.class);
            String errorDetail = errorList.stream().map(m -> (String) JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class).get("errorDetail")).collect(Collectors.joining(", "));
            return RestResponse.fail(errorDetail);
        }

        return RestResponse.success();
    }


}
