/*
 * Decompiled with CFR 0.152.
 */
package org.eetrust.security.client.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonUtils {
    private static final Log log = LogFactory.getLog(CommonUtils.class);

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotEmpty(Collection<?> c, String message) {
        CommonUtils.assertNotNull(c, message);
        if (c.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertTrue(boolean cond, String message) {
        if (!cond) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return !CommonUtils.isEmpty(string);
    }

    public static boolean isBlank(String string) {
        return CommonUtils.isEmpty(string) || string.trim().length() == 0;
    }

    public static boolean isNotBlank(String string) {
        return !CommonUtils.isBlank(string);
    }

    public static String constructRedirectUrl(String eamServerLoginUrl, String serviceParameterName, String serviceUrl, String appCode) {
        try {
            return String.valueOf(eamServerLoginUrl) + (eamServerLoginUrl.indexOf("?") != -1 ? "&" : "?") + serviceParameterName + "=" + URLEncoder.encode(serviceUrl, "UTF-8") + "&appCode=" + appCode;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, String service, String serverName, String ticketParameterName, boolean encode) {
        String returnValue;
        StringBuffer buffer;
        if (CommonUtils.isNotBlank(service)) {
            return encode ? response.encodeURL(service) : service;
        }
        StringBuffer stringBuffer = buffer = new StringBuffer();
        synchronized (stringBuffer) {
            if (!serverName.startsWith("https://") && !serverName.startsWith("http://")) {
                buffer.append(request.isSecure() ? "https://" : "http://");
            }
            buffer.append(serverName);
            buffer.append(request.getRequestURI());
            if (CommonUtils.isNotBlank(request.getQueryString())) {
                int location = request.getQueryString().indexOf(String.valueOf(ticketParameterName) + "=");
                if (location == 0) {
                    String returnValue2;
                    String string = returnValue2 = encode ? response.encodeURL(buffer.toString()) : buffer.toString();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("serviceUrl generated: " + returnValue2));
                    }
                    return returnValue2;
                }
                buffer.append("?");
                if (location == -1) {
                    buffer.append(request.getQueryString());
                } else if (location > 0) {
                    int actualLocation = request.getQueryString().indexOf("&" + ticketParameterName + "=");
                    if (actualLocation == -1) {
                        buffer.append(request.getQueryString());
                    } else if (actualLocation > 0) {
                        buffer.append(request.getQueryString().substring(0, actualLocation));
                    }
                }
            }
        }
        String string = returnValue = encode ? response.encodeURL(buffer.toString()) : buffer.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("serviceUrl generated: " + returnValue));
        }
        return returnValue;
    }

    public static String safeGetParameter(HttpServletRequest request, String parameter) {
        if ("POST".equals(request.getMethod()) && "logoutRequest".equals(parameter)) {
            log.debug((Object)"safeGetParameter called on a POST HttpServletRequest for LogoutRequest.  Cannot complete check safely.  Reverting to standard behavior for this Parameter");
            return request.getParameter(parameter);
        }
        return request.getQueryString() == null || request.getQueryString().indexOf(parameter) == -1 ? null : request.getParameter(parameter);
    }

    public static void sendRedirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }
}

