/*
 * Decompiled with CFR 0.152.
 */
package com.eetrust.security.plugin;

import com.eetrust.security.plugin.RequestException;
import com.eetrust.security.plugin.ssl.SSLProtocolSocketFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class HttpUtils {
    public static final String URL_PARAM_DECODECHARSET_UTF8 = "UTF-8";
    public static final String URL_PARAM_DECODECHARSET_GBK = "GBK";
    private static final String URL_PARAM_CONNECT_FLAG = "&";
    private static final String EMPTY = "";
    private static MultiThreadedHttpConnectionManager connectionManager = null;
    private static int connectionTimeOut = 60000;
    private static int socketTimeOut = 60000;
    private static int maxConnectionPerHost = 20;
    private static int maxTotalConnections = 300;
    private static HttpClient client;

    static {
        connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setConnectionTimeout(connectionTimeOut);
        connectionManager.getParams().setSoTimeout(socketTimeOut);
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(maxConnectionPerHost);
        connectionManager.getParams().setMaxTotalConnections(maxTotalConnections);
        client = new HttpClient((HttpConnectionManager)connectionManager);
    }

    public static String URLPost(String url, Map<String, String> params, String enc) throws RequestException {
        return HttpUtils.URLPost(url, params, enc, false, null);
    }

    public static String URLPost(String url, Map<String, String> params, String enc, boolean sslProtocol, Integer sslPort) throws RequestException {
        StringBuffer resultBuffer;
        block12: {
            if (sslProtocol && sslPort != null) {
                Protocol httpsProtocol = new Protocol("https", (ProtocolSocketFactory)new SSLProtocolSocketFactory(), sslPort.intValue());
                Protocol.registerProtocol((String)"https", (Protocol)httpsProtocol);
            }
            resultBuffer = new StringBuffer();
            PostMethod postMethod = null;
            try {
                try {
                    int statusCode;
                    postMethod = new PostMethod(url);
                    postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + enc);
                    if (params != null) {
                        Set<String> keySet = params.keySet();
                        for (String key : keySet) {
                            String value = params.get(key);
                            postMethod.addParameter(key, value);
                        }
                    }
                    if ((statusCode = client.executeMethod((HttpMethod)postMethod)) == 200) {
                        BufferedReader in = new BufferedReader(new InputStreamReader(postMethod.getResponseBodyAsStream(), postMethod.getResponseCharSet()));
                        String inputLine = null;
                        while ((inputLine = in.readLine()) != null) {
                            resultBuffer.append(inputLine);
                            resultBuffer.append("\n");
                        }
                        break block12;
                    }
                    throw new RequestException();
                }
                catch (HttpException e) {
                    throw new RequestException();
                }
                catch (IOException e) {
                    throw new RequestException();
                }
            }
            finally {
                if (postMethod != null) {
                    postMethod.releaseConnection();
                    postMethod = null;
                }
            }
        }
        return resultBuffer.toString();
    }

    public static String URLGet(String url, Map<String, String> params, String enc) throws RequestException {
        return HttpUtils.URLGet(url, params, enc, false, null);
    }

    public static String URLGet(String url, Map<String, String> params, String enc, boolean sslProtocol, Integer sslPort) throws RequestException {
        StringBuffer resultBuffer;
        block15: {
            if (sslProtocol && sslPort != null) {
                Protocol httpsProtocol = new Protocol("https", (ProtocolSocketFactory)new SSLProtocolSocketFactory(), sslPort.intValue());
                Protocol.registerProtocol((String)"https", (Protocol)httpsProtocol);
            }
            GetMethod getMethod = null;
            resultBuffer = new StringBuffer();
            StringBuffer strtTotalURL = new StringBuffer(EMPTY);
            if (params != null) {
                if (url.indexOf("?") == -1) {
                    strtTotalURL.append(url).append("?").append(HttpUtils.getUrl(params, enc));
                } else if (url.indexOf("?") > 0) {
                    strtTotalURL.append(url).append(URL_PARAM_CONNECT_FLAG).append(HttpUtils.getUrl(params, enc));
                }
            } else {
                strtTotalURL.append(url);
            }
            try {
                try {
                    getMethod = new GetMethod(strtTotalURL.toString());
                    getMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + enc);
                    int statusCode = client.executeMethod((HttpMethod)getMethod);
                    if (statusCode == 200) {
                        BufferedReader in = new BufferedReader(new InputStreamReader(getMethod.getResponseBodyAsStream(), getMethod.getResponseCharSet()));
                        String inputLine = null;
                        while ((inputLine = in.readLine()) != null) {
                            resultBuffer.append(inputLine);
                            resultBuffer.append("\n");
                        }
                        break block15;
                    }
                    throw new RequestException();
                }
                catch (HttpException e) {
                    throw new RequestException();
                }
                catch (IOException e) {
                    throw new RequestException();
                }
            }
            finally {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                    getMethod = null;
                }
            }
        }
        return resultBuffer.toString();
    }

    private static String getUrl(Map<String, String> map, String valueEnc) {
        if (map == null || map.keySet().size() == 0) {
            return EMPTY;
        }
        StringBuffer url = new StringBuffer();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            if (!map.containsKey(key)) continue;
            String val = map.get(key);
            String str = val != null ? val : EMPTY;
            try {
                str = URLEncoder.encode(str, valueEnc);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            url.append(key).append("=").append(str).append(URL_PARAM_CONNECT_FLAG);
        }
        String strURL = EMPTY;
        strURL = url.toString();
        if (URL_PARAM_CONNECT_FLAG.equals(EMPTY + strURL.charAt(strURL.length() - 1))) {
            strURL = strURL.substring(0, strURL.length() - 1);
        }
        return strURL;
    }
}

