package com.shr.serivce.impl;

import com.shr.dao.LogMapper;
import com.shr.serivce.ILogService;
import com.shr.transfer.log.LogListInVo;
import com.shr.transfer.log.LogListOutVo;
import com.shr.transfer.log.LogListOutVoRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.List;

/**
 * @author Inori
 */
@Service
public class LogServiceImpl implements ILogService {

    @Autowired
    private LogMapper logMapper;


    @PostConstruct
    public void init() {
        Integer isTable = logMapper.isTable();
        System.out.println("+++++++++++>" + isTable);
        if (isTable == 0) {
            logMapper.createTable();
        }
    }

    @Override
    public LogListOutVo logList(LogListInVo inVo) {
        List<LogListOutVoRecords> recordsList = logMapper.logList(inVo);

        LogListOutVo outVo = new LogListOutVo();
        outVo.setRecords(recordsList);
        return outVo;
    }


}
